/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCopyImageToImageInfo;
import org.lwjgl.vulkan.VkImageCopy2;

public class VkCopyImageToImageInfoEXT
extends VkCopyImageToImageInfo {
    protected VkCopyImageToImageInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyImageToImageInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToImageInfoEXT(address, container);
    }

    public VkCopyImageToImageInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkCopyImageToImageInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToImageInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT sType$Default() {
        return this.sType(1000270007);
    }

    @Override
    public VkCopyImageToImageInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToImageInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyImageToImageInfoEXT.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfoEXT.nsrcImage(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT dstImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToImageInfoEXT.ndstImage(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT dstImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToImageInfoEXT.ndstImageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
        VkCopyImageToImageInfoEXT.npRegions(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToImageInfoEXT set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, long dstImage, int dstImageLayout, VkImageCopy2.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.dstImage(dstImage);
        this.dstImageLayout(dstImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToImageInfoEXT set(VkCopyImageToImageInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyImageToImageInfoEXT malloc() {
        return new VkCopyImageToImageInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT calloc() {
        return new VkCopyImageToImageInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyImageToImageInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyImageToImageInfoEXT create(long address) {
        return new VkCopyImageToImageInfoEXT(address, null);
    }

    public static @Nullable VkCopyImageToImageInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToImageInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyImageToImageInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToImageInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToImageInfoEXT malloc(MemoryStack stack) {
        return new VkCopyImageToImageInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToImageInfoEXT calloc(MemoryStack stack) {
        return new VkCopyImageToImageInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkCopyImageToImageInfo.Buffer {
        private static final VkCopyImageToImageInfoEXT ELEMENT_FACTORY = VkCopyImageToImageInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCopyImageToImageInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToImageInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270007);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToImageInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyImageToImageInfoEXT.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfoEXT.nsrcImage(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfoEXT.nsrcImageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToImageInfoEXT.ndstImage(this.address(), value);
            return this;
        }

        @Override
        public Buffer dstImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToImageInfoEXT.ndstImageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer pRegions(@NativeType(value="VkImageCopy2 const *") VkImageCopy2.Buffer value) {
            VkCopyImageToImageInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

