/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCopyImageToMemoryInfo;
import org.lwjgl.vulkan.VkImageToMemoryCopy;

public class VkCopyImageToMemoryInfoEXT
extends VkCopyImageToMemoryInfo {
    protected VkCopyImageToMemoryInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCopyImageToMemoryInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkCopyImageToMemoryInfoEXT(address, container);
    }

    public VkCopyImageToMemoryInfoEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkCopyImageToMemoryInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkCopyImageToMemoryInfoEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT sType$Default() {
        return this.sType(1000270004);
    }

    @Override
    public VkCopyImageToMemoryInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkCopyImageToMemoryInfoEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT flags(@NativeType(value="VkHostImageCopyFlags") int value) {
        VkCopyImageToMemoryInfoEXT.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT srcImage(@NativeType(value="VkImage") long value) {
        VkCopyImageToMemoryInfoEXT.nsrcImage(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT srcImageLayout(@NativeType(value="VkImageLayout") int value) {
        VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT pRegions(@NativeType(value="VkImageToMemoryCopy const *") VkImageToMemoryCopy.Buffer value) {
        VkCopyImageToMemoryInfoEXT.npRegions(this.address(), value);
        return this;
    }

    @Override
    public VkCopyImageToMemoryInfoEXT set(int sType, long pNext, int flags, long srcImage, int srcImageLayout, VkImageToMemoryCopy.Buffer pRegions) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.srcImage(srcImage);
        this.srcImageLayout(srcImageLayout);
        this.pRegions(pRegions);
        return this;
    }

    public VkCopyImageToMemoryInfoEXT set(VkCopyImageToMemoryInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCopyImageToMemoryInfoEXT malloc() {
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT calloc() {
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCopyImageToMemoryInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkCopyImageToMemoryInfoEXT create(long address) {
        return new VkCopyImageToMemoryInfoEXT(address, null);
    }

    public static @Nullable VkCopyImageToMemoryInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkCopyImageToMemoryInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCopyImageToMemoryInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCopyImageToMemoryInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCopyImageToMemoryInfoEXT malloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCopyImageToMemoryInfoEXT calloc(MemoryStack stack) {
        return new VkCopyImageToMemoryInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkCopyImageToMemoryInfo.Buffer {
        private static final VkCopyImageToMemoryInfoEXT ELEMENT_FACTORY = VkCopyImageToMemoryInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCopyImageToMemoryInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCopyImageToMemoryInfoEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270004);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCopyImageToMemoryInfoEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkHostImageCopyFlags") int value) {
            VkCopyImageToMemoryInfoEXT.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcImage(@NativeType(value="VkImage") long value) {
            VkCopyImageToMemoryInfoEXT.nsrcImage(this.address(), value);
            return this;
        }

        @Override
        public Buffer srcImageLayout(@NativeType(value="VkImageLayout") int value) {
            VkCopyImageToMemoryInfoEXT.nsrcImageLayout(this.address(), value);
            return this;
        }

        @Override
        public Buffer pRegions(@NativeType(value="VkImageToMemoryCopy const *") VkImageToMemoryCopy.Buffer value) {
            VkCopyImageToMemoryInfoEXT.npRegions(this.address(), value);
            return this;
        }
    }
}

