/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkCuFunctionCreateInfoNVX
extends Struct<VkCuFunctionCreateInfoNVX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int MODULE;
    public static final int PNAME;

    protected VkCuFunctionCreateInfoNVX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkCuFunctionCreateInfoNVX create(long address, @Nullable ByteBuffer container) {
        return new VkCuFunctionCreateInfoNVX(address, container);
    }

    public VkCuFunctionCreateInfoNVX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkCuFunctionCreateInfoNVX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkCuFunctionCreateInfoNVX.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkCuFunctionCreateInfoNVX.npNext(this.address());
    }

    @NativeType(value="VkCuModuleNVX")
    public long module() {
        return VkCuFunctionCreateInfoNVX.nmodule(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer pName() {
        return VkCuFunctionCreateInfoNVX.npName(this.address());
    }

    @NativeType(value="char const *")
    public String pNameString() {
        return VkCuFunctionCreateInfoNVX.npNameString(this.address());
    }

    public VkCuFunctionCreateInfoNVX sType(@NativeType(value="VkStructureType") int value) {
        VkCuFunctionCreateInfoNVX.nsType(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX sType$Default() {
        return this.sType(1000029001);
    }

    public VkCuFunctionCreateInfoNVX pNext(@NativeType(value="void const *") long value) {
        VkCuFunctionCreateInfoNVX.npNext(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX module(@NativeType(value="VkCuModuleNVX") long value) {
        VkCuFunctionCreateInfoNVX.nmodule(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX pName(@NativeType(value="char const *") ByteBuffer value) {
        VkCuFunctionCreateInfoNVX.npName(this.address(), value);
        return this;
    }

    public VkCuFunctionCreateInfoNVX set(int sType, long pNext, long module, ByteBuffer pName) {
        this.sType(sType);
        this.pNext(pNext);
        this.module(module);
        this.pName(pName);
        return this;
    }

    public VkCuFunctionCreateInfoNVX set(VkCuFunctionCreateInfoNVX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkCuFunctionCreateInfoNVX malloc() {
        return new VkCuFunctionCreateInfoNVX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkCuFunctionCreateInfoNVX calloc() {
        return new VkCuFunctionCreateInfoNVX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkCuFunctionCreateInfoNVX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkCuFunctionCreateInfoNVX(MemoryUtil.memAddress(container), container);
    }

    public static VkCuFunctionCreateInfoNVX create(long address) {
        return new VkCuFunctionCreateInfoNVX(address, null);
    }

    public static @Nullable VkCuFunctionCreateInfoNVX createSafe(long address) {
        return address == 0L ? null : new VkCuFunctionCreateInfoNVX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkCuFunctionCreateInfoNVX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkCuFunctionCreateInfoNVX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkCuFunctionCreateInfoNVX malloc(MemoryStack stack) {
        return new VkCuFunctionCreateInfoNVX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkCuFunctionCreateInfoNVX calloc(MemoryStack stack) {
        return new VkCuFunctionCreateInfoNVX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nmodule(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MODULE);
    }

    public static ByteBuffer npName(long struct) {
        return MemoryUtil.memByteBufferNT1(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    public static String npNameString(long struct) {
        return MemoryUtil.memUTF8(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nmodule(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MODULE, value);
    }

    public static void npName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1(value);
        }
        MemoryUtil.memPutAddress(struct + (long)PNAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PNAME));
    }

    static {
        Struct.Layout layout = VkCuFunctionCreateInfoNVX.__struct(VkCuFunctionCreateInfoNVX.__member(4), VkCuFunctionCreateInfoNVX.__member(POINTER_SIZE), VkCuFunctionCreateInfoNVX.__member(8), VkCuFunctionCreateInfoNVX.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        MODULE = layout.offsetof(2);
        PNAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkCuFunctionCreateInfoNVX, Buffer>
    implements NativeResource {
        private static final VkCuFunctionCreateInfoNVX ELEMENT_FACTORY = VkCuFunctionCreateInfoNVX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkCuFunctionCreateInfoNVX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkCuFunctionCreateInfoNVX.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkCuFunctionCreateInfoNVX.npNext(this.address());
        }

        @NativeType(value="VkCuModuleNVX")
        public long module() {
            return VkCuFunctionCreateInfoNVX.nmodule(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer pName() {
            return VkCuFunctionCreateInfoNVX.npName(this.address());
        }

        @NativeType(value="char const *")
        public String pNameString() {
            return VkCuFunctionCreateInfoNVX.npNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkCuFunctionCreateInfoNVX.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000029001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkCuFunctionCreateInfoNVX.npNext(this.address(), value);
            return this;
        }

        public Buffer module(@NativeType(value="VkCuModuleNVX") long value) {
            VkCuFunctionCreateInfoNVX.nmodule(this.address(), value);
            return this;
        }

        public Buffer pName(@NativeType(value="char const *") ByteBuffer value) {
            VkCuFunctionCreateInfoNVX.npName(this.address(), value);
            return this;
        }
    }
}

