/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectTagInfoEXT
extends Struct<VkDebugMarkerObjectTagInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int TAGNAME;
    public static final int TAGSIZE;
    public static final int PTAG;

    protected VkDebugMarkerObjectTagInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDebugMarkerObjectTagInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDebugMarkerObjectTagInfoEXT(address, container);
    }

    public VkDebugMarkerObjectTagInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDebugMarkerObjectTagInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugReportObjectTypeEXT")
    public int objectType() {
        return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long object() {
        return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
    }

    @NativeType(value="uint64_t")
    public long tagName() {
        return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
    }

    @NativeType(value="size_t")
    public long tagSize() {
        return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pTag() {
        return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
    }

    public VkDebugMarkerObjectTagInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT sType$Default() {
        return this.sType(1000022001);
    }

    public VkDebugMarkerObjectTagInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
        VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT object(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT tagName(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT pTag(@NativeType(value="void const *") ByteBuffer value) {
        VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(int sType, long pNext, int objectType, long object, long tagName, ByteBuffer pTag) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.tagName(tagName);
        this.pTag(pTag);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(VkDebugMarkerObjectTagInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDebugMarkerObjectTagInfoEXT malloc() {
        return new VkDebugMarkerObjectTagInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDebugMarkerObjectTagInfoEXT calloc() {
        return new VkDebugMarkerObjectTagInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDebugMarkerObjectTagInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDebugMarkerObjectTagInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDebugMarkerObjectTagInfoEXT create(long address) {
        return new VkDebugMarkerObjectTagInfoEXT(address, null);
    }

    public static @Nullable VkDebugMarkerObjectTagInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDebugMarkerObjectTagInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDebugMarkerObjectTagInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugMarkerObjectTagInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT mallocStack() {
        return VkDebugMarkerObjectTagInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT callocStack() {
        return VkDebugMarkerObjectTagInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugMarkerObjectTagInfoEXT malloc(MemoryStack stack) {
        return new VkDebugMarkerObjectTagInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDebugMarkerObjectTagInfoEXT calloc(MemoryStack stack) {
        return new VkDebugMarkerObjectTagInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nobjectType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OBJECT);
    }

    public static long ntagName(long struct) {
        return MemoryUtil.memGetLong(struct + (long)TAGNAME);
    }

    public static long ntagSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)TAGSIZE);
    }

    public static ByteBuffer npTag(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PTAG), (int)VkDebugMarkerObjectTagInfoEXT.ntagSize(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nobjectType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OBJECT, value);
    }

    public static void ntagName(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)TAGNAME, value);
    }

    public static void ntagSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)TAGSIZE, value);
    }

    public static void npTag(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PTAG, MemoryUtil.memAddress(value));
        VkDebugMarkerObjectTagInfoEXT.ntagSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PTAG));
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectTagInfoEXT.__struct(VkDebugMarkerObjectTagInfoEXT.__member(4), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member(4), VkDebugMarkerObjectTagInfoEXT.__member(8), VkDebugMarkerObjectTagInfoEXT.__member(8), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        TAGNAME = layout.offsetof(4);
        TAGSIZE = layout.offsetof(5);
        PTAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerObjectTagInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugMarkerObjectTagInfoEXT ELEMENT_FACTORY = VkDebugMarkerObjectTagInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDebugMarkerObjectTagInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugReportObjectTypeEXT")
        public int objectType() {
            return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long object() {
            return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
        }

        @NativeType(value="uint64_t")
        public long tagName() {
            return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
        }

        @NativeType(value="size_t")
        public long tagSize() {
            return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pTag() {
            return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000022001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
            VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer tagName(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
            return this;
        }

        public Buffer pTag(@NativeType(value="void const *") ByteBuffer value) {
            VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
            return this;
        }
    }
}

