/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDepthBiasRepresentationInfoEXT;

public class VkDepthBiasInfoEXT
extends Struct<VkDepthBiasInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DEPTHBIASCONSTANTFACTOR;
    public static final int DEPTHBIASCLAMP;
    public static final int DEPTHBIASSLOPEFACTOR;

    protected VkDepthBiasInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDepthBiasInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDepthBiasInfoEXT(address, container);
    }

    public VkDepthBiasInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDepthBiasInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDepthBiasInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDepthBiasInfoEXT.npNext(this.address());
    }

    public float depthBiasConstantFactor() {
        return VkDepthBiasInfoEXT.ndepthBiasConstantFactor(this.address());
    }

    public float depthBiasClamp() {
        return VkDepthBiasInfoEXT.ndepthBiasClamp(this.address());
    }

    public float depthBiasSlopeFactor() {
        return VkDepthBiasInfoEXT.ndepthBiasSlopeFactor(this.address());
    }

    public VkDepthBiasInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDepthBiasInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDepthBiasInfoEXT sType$Default() {
        return this.sType(1000283001);
    }

    public VkDepthBiasInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDepthBiasInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDepthBiasInfoEXT pNext(VkDepthBiasRepresentationInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDepthBiasInfoEXT depthBiasConstantFactor(float value) {
        VkDepthBiasInfoEXT.ndepthBiasConstantFactor(this.address(), value);
        return this;
    }

    public VkDepthBiasInfoEXT depthBiasClamp(float value) {
        VkDepthBiasInfoEXT.ndepthBiasClamp(this.address(), value);
        return this;
    }

    public VkDepthBiasInfoEXT depthBiasSlopeFactor(float value) {
        VkDepthBiasInfoEXT.ndepthBiasSlopeFactor(this.address(), value);
        return this;
    }

    public VkDepthBiasInfoEXT set(int sType, long pNext, float depthBiasConstantFactor, float depthBiasClamp, float depthBiasSlopeFactor) {
        this.sType(sType);
        this.pNext(pNext);
        this.depthBiasConstantFactor(depthBiasConstantFactor);
        this.depthBiasClamp(depthBiasClamp);
        this.depthBiasSlopeFactor(depthBiasSlopeFactor);
        return this;
    }

    public VkDepthBiasInfoEXT set(VkDepthBiasInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDepthBiasInfoEXT malloc() {
        return new VkDepthBiasInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDepthBiasInfoEXT calloc() {
        return new VkDepthBiasInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDepthBiasInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDepthBiasInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDepthBiasInfoEXT create(long address) {
        return new VkDepthBiasInfoEXT(address, null);
    }

    public static @Nullable VkDepthBiasInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDepthBiasInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDepthBiasInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDepthBiasInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDepthBiasInfoEXT malloc(MemoryStack stack) {
        return new VkDepthBiasInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDepthBiasInfoEXT calloc(MemoryStack stack) {
        return new VkDepthBiasInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static float ndepthBiasConstantFactor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEPTHBIASCONSTANTFACTOR);
    }

    public static float ndepthBiasClamp(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEPTHBIASCLAMP);
    }

    public static float ndepthBiasSlopeFactor(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DEPTHBIASSLOPEFACTOR);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ndepthBiasConstantFactor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEPTHBIASCONSTANTFACTOR, value);
    }

    public static void ndepthBiasClamp(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEPTHBIASCLAMP, value);
    }

    public static void ndepthBiasSlopeFactor(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DEPTHBIASSLOPEFACTOR, value);
    }

    static {
        Struct.Layout layout = VkDepthBiasInfoEXT.__struct(VkDepthBiasInfoEXT.__member(4), VkDepthBiasInfoEXT.__member(POINTER_SIZE), VkDepthBiasInfoEXT.__member(4), VkDepthBiasInfoEXT.__member(4), VkDepthBiasInfoEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DEPTHBIASCONSTANTFACTOR = layout.offsetof(2);
        DEPTHBIASCLAMP = layout.offsetof(3);
        DEPTHBIASSLOPEFACTOR = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkDepthBiasInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDepthBiasInfoEXT ELEMENT_FACTORY = VkDepthBiasInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDepthBiasInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDepthBiasInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDepthBiasInfoEXT.npNext(this.address());
        }

        public float depthBiasConstantFactor() {
            return VkDepthBiasInfoEXT.ndepthBiasConstantFactor(this.address());
        }

        public float depthBiasClamp() {
            return VkDepthBiasInfoEXT.ndepthBiasClamp(this.address());
        }

        public float depthBiasSlopeFactor() {
            return VkDepthBiasInfoEXT.ndepthBiasSlopeFactor(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDepthBiasInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000283001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDepthBiasInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDepthBiasRepresentationInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer depthBiasConstantFactor(float value) {
            VkDepthBiasInfoEXT.ndepthBiasConstantFactor(this.address(), value);
            return this;
        }

        public Buffer depthBiasClamp(float value) {
            VkDepthBiasInfoEXT.ndepthBiasClamp(this.address(), value);
            return this;
        }

        public Buffer depthBiasSlopeFactor(float value) {
            VkDepthBiasInfoEXT.ndepthBiasSlopeFactor(this.address(), value);
            return this;
        }
    }
}

