/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorBufferInfo
extends Struct<VkDescriptorBufferInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int BUFFER;
    public static final int OFFSET;
    public static final int RANGE;

    protected VkDescriptorBufferInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorBufferInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorBufferInfo(address, container);
    }

    public VkDescriptorBufferInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorBufferInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkBuffer")
    public long buffer() {
        return VkDescriptorBufferInfo.nbuffer(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long offset() {
        return VkDescriptorBufferInfo.noffset(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long range() {
        return VkDescriptorBufferInfo.nrange(this.address());
    }

    public VkDescriptorBufferInfo buffer(@NativeType(value="VkBuffer") long value) {
        VkDescriptorBufferInfo.nbuffer(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo offset(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.noffset(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo range(@NativeType(value="VkDeviceSize") long value) {
        VkDescriptorBufferInfo.nrange(this.address(), value);
        return this;
    }

    public VkDescriptorBufferInfo set(long buffer, long offset, long range) {
        this.buffer(buffer);
        this.offset(offset);
        this.range(range);
        return this;
    }

    public VkDescriptorBufferInfo set(VkDescriptorBufferInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorBufferInfo malloc() {
        return new VkDescriptorBufferInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorBufferInfo calloc() {
        return new VkDescriptorBufferInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorBufferInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorBufferInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorBufferInfo create(long address) {
        return new VkDescriptorBufferInfo(address, null);
    }

    public static @Nullable VkDescriptorBufferInfo createSafe(long address) {
        return address == 0L ? null : new VkDescriptorBufferInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorBufferInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorBufferInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorBufferInfo mallocStack() {
        return VkDescriptorBufferInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorBufferInfo callocStack() {
        return VkDescriptorBufferInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorBufferInfo mallocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorBufferInfo callocStack(MemoryStack stack) {
        return VkDescriptorBufferInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorBufferInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorBufferInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorBufferInfo.calloc(capacity, stack);
    }

    public static VkDescriptorBufferInfo malloc(MemoryStack stack) {
        return new VkDescriptorBufferInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorBufferInfo calloc(MemoryStack stack) {
        return new VkDescriptorBufferInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nbuffer(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BUFFER);
    }

    public static long noffset(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OFFSET);
    }

    public static long nrange(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RANGE);
    }

    public static void nbuffer(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BUFFER, value);
    }

    public static void noffset(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OFFSET, value);
    }

    public static void nrange(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RANGE, value);
    }

    static {
        Struct.Layout layout = VkDescriptorBufferInfo.__struct(VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8), VkDescriptorBufferInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        BUFFER = layout.offsetof(0);
        OFFSET = layout.offsetof(1);
        RANGE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorBufferInfo, Buffer>
    implements NativeResource {
        private static final VkDescriptorBufferInfo ELEMENT_FACTORY = VkDescriptorBufferInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDescriptorBufferInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkBuffer")
        public long buffer() {
            return VkDescriptorBufferInfo.nbuffer(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long offset() {
            return VkDescriptorBufferInfo.noffset(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long range() {
            return VkDescriptorBufferInfo.nrange(this.address());
        }

        public Buffer buffer(@NativeType(value="VkBuffer") long value) {
            VkDescriptorBufferInfo.nbuffer(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.noffset(this.address(), value);
            return this;
        }

        public Buffer range(@NativeType(value="VkDeviceSize") long value) {
            VkDescriptorBufferInfo.nrange(this.address(), value);
            return this;
        }
    }
}

