/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDescriptorSetVariableDescriptorCountLayoutSupport;
import org.lwjgl.vulkan.VkDescriptorSetVariableDescriptorCountLayoutSupportEXT;

public class VkDescriptorSetLayoutSupport
extends Struct<VkDescriptorSetLayoutSupport>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SUPPORTED;

    protected VkDescriptorSetLayoutSupport(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorSetLayoutSupport create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorSetLayoutSupport(address, container);
    }

    public VkDescriptorSetLayoutSupport(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorSetLayoutSupport.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDescriptorSetLayoutSupport.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkDescriptorSetLayoutSupport.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean supported() {
        return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
    }

    public VkDescriptorSetLayoutSupport sType(@NativeType(value="VkStructureType") int value) {
        VkDescriptorSetLayoutSupport.nsType(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport sType$Default() {
        return this.sType(1000168001);
    }

    public VkDescriptorSetLayoutSupport pNext(@NativeType(value="void *") long value) {
        VkDescriptorSetLayoutSupport.npNext(this.address(), value);
        return this;
    }

    public VkDescriptorSetLayoutSupport pNext(VkDescriptorSetVariableDescriptorCountLayoutSupport value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutSupport pNext(VkDescriptorSetVariableDescriptorCountLayoutSupportEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkDescriptorSetLayoutSupport set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkDescriptorSetLayoutSupport set(VkDescriptorSetLayoutSupport src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorSetLayoutSupport malloc() {
        return new VkDescriptorSetLayoutSupport(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorSetLayoutSupport calloc() {
        return new VkDescriptorSetLayoutSupport(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorSetLayoutSupport create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorSetLayoutSupport(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorSetLayoutSupport create(long address) {
        return new VkDescriptorSetLayoutSupport(address, null);
    }

    public static @Nullable VkDescriptorSetLayoutSupport createSafe(long address) {
        return address == 0L ? null : new VkDescriptorSetLayoutSupport(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorSetLayoutSupport.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorSetLayoutSupport.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorSetLayoutSupport mallocStack() {
        return VkDescriptorSetLayoutSupport.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutSupport callocStack() {
        return VkDescriptorSetLayoutSupport.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorSetLayoutSupport mallocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorSetLayoutSupport callocStack(MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorSetLayoutSupport.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorSetLayoutSupport.calloc(capacity, stack);
    }

    public static VkDescriptorSetLayoutSupport malloc(MemoryStack stack) {
        return new VkDescriptorSetLayoutSupport(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorSetLayoutSupport calloc(MemoryStack stack) {
        return new VkDescriptorSetLayoutSupport(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nsupported(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTED);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorSetLayoutSupport.__struct(VkDescriptorSetLayoutSupport.__member(4), VkDescriptorSetLayoutSupport.__member(POINTER_SIZE), VkDescriptorSetLayoutSupport.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SUPPORTED = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorSetLayoutSupport, Buffer>
    implements NativeResource {
        private static final VkDescriptorSetLayoutSupport ELEMENT_FACTORY = VkDescriptorSetLayoutSupport.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDescriptorSetLayoutSupport getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDescriptorSetLayoutSupport.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkDescriptorSetLayoutSupport.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean supported() {
            return VkDescriptorSetLayoutSupport.nsupported(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDescriptorSetLayoutSupport.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000168001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkDescriptorSetLayoutSupport.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDescriptorSetVariableDescriptorCountLayoutSupport value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDescriptorSetVariableDescriptorCountLayoutSupportEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

