/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageSubresource2;

public class VkDeviceImageSubresourceInfo
extends Struct<VkDeviceImageSubresourceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;
    public static final int PSUBRESOURCE;

    protected VkDeviceImageSubresourceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceImageSubresourceInfo create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceImageSubresourceInfo(address, container);
    }

    public VkDeviceImageSubresourceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceImageSubresourceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceImageSubresourceInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceImageSubresourceInfo.npNext(this.address());
    }

    @NativeType(value="VkImageCreateInfo const *")
    public VkImageCreateInfo pCreateInfo() {
        return VkDeviceImageSubresourceInfo.npCreateInfo(this.address());
    }

    @NativeType(value="VkImageSubresource2 const *")
    public VkImageSubresource2 pSubresource() {
        return VkDeviceImageSubresourceInfo.npSubresource(this.address());
    }

    public VkDeviceImageSubresourceInfo sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceImageSubresourceInfo.nsType(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo sType$Default() {
        return this.sType(1000470004);
    }

    public VkDeviceImageSubresourceInfo pNext(@NativeType(value="void const *") long value) {
        VkDeviceImageSubresourceInfo.npNext(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
        VkDeviceImageSubresourceInfo.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo pSubresource(@NativeType(value="VkImageSubresource2 const *") VkImageSubresource2 value) {
        VkDeviceImageSubresourceInfo.npSubresource(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfo set(int sType, long pNext, VkImageCreateInfo pCreateInfo, VkImageSubresource2 pSubresource) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        this.pSubresource(pSubresource);
        return this;
    }

    public VkDeviceImageSubresourceInfo set(VkDeviceImageSubresourceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceImageSubresourceInfo malloc() {
        return new VkDeviceImageSubresourceInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo calloc() {
        return new VkDeviceImageSubresourceInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceImageSubresourceInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceImageSubresourceInfo create(long address) {
        return new VkDeviceImageSubresourceInfo(address, null);
    }

    public static @Nullable VkDeviceImageSubresourceInfo createSafe(long address) {
        return address == 0L ? null : new VkDeviceImageSubresourceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceImageSubresourceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceImageSubresourceInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceImageSubresourceInfo malloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfo calloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkImageCreateInfo npCreateInfo(long struct) {
        return VkImageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    public static VkImageSubresource2 npSubresource(long struct) {
        return VkImageSubresource2.create(MemoryUtil.memGetAddress(struct + (long)PSUBRESOURCE));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npCreateInfo(long struct, VkImageCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCREATEINFO, value.address());
    }

    public static void npSubresource(long struct, VkImageSubresource2 value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBRESOURCE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSUBRESOURCE));
    }

    static {
        Struct.Layout layout = VkDeviceImageSubresourceInfo.__struct(VkDeviceImageSubresourceInfo.__member(4), VkDeviceImageSubresourceInfo.__member(POINTER_SIZE), VkDeviceImageSubresourceInfo.__member(POINTER_SIZE), VkDeviceImageSubresourceInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
        PSUBRESOURCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceImageSubresourceInfo, Buffer>
    implements NativeResource {
        private static final VkDeviceImageSubresourceInfo ELEMENT_FACTORY = VkDeviceImageSubresourceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDeviceImageSubresourceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceImageSubresourceInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceImageSubresourceInfo.npNext(this.address());
        }

        @NativeType(value="VkImageCreateInfo const *")
        public VkImageCreateInfo pCreateInfo() {
            return VkDeviceImageSubresourceInfo.npCreateInfo(this.address());
        }

        @NativeType(value="VkImageSubresource2 const *")
        public VkImageSubresource2 pSubresource() {
            return VkDeviceImageSubresourceInfo.npSubresource(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceImageSubresourceInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000470004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceImageSubresourceInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
            VkDeviceImageSubresourceInfo.npCreateInfo(this.address(), value);
            return this;
        }

        public Buffer pSubresource(@NativeType(value="VkImageSubresource2 const *") VkImageSubresource2 value) {
            VkDeviceImageSubresourceInfo.npSubresource(this.address(), value);
            return this;
        }
    }
}

