/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDisplayPlanePropertiesKHR
extends Struct<VkDisplayPlanePropertiesKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURRENTDISPLAY;
    public static final int CURRENTSTACKINDEX;

    protected VkDisplayPlanePropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDisplayPlanePropertiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDisplayPlanePropertiesKHR(address, container);
    }

    public VkDisplayPlanePropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDisplayPlanePropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDisplayKHR")
    public long currentDisplay() {
        return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
    }

    @NativeType(value="uint32_t")
    public int currentStackIndex() {
        return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
    }

    public static VkDisplayPlanePropertiesKHR malloc() {
        return new VkDisplayPlanePropertiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDisplayPlanePropertiesKHR calloc() {
        return new VkDisplayPlanePropertiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDisplayPlanePropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDisplayPlanePropertiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDisplayPlanePropertiesKHR create(long address) {
        return new VkDisplayPlanePropertiesKHR(address, null);
    }

    public static @Nullable VkDisplayPlanePropertiesKHR createSafe(long address) {
        return address == 0L ? null : new VkDisplayPlanePropertiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDisplayPlanePropertiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDisplayPlanePropertiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR mallocStack() {
        return VkDisplayPlanePropertiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR callocStack() {
        return VkDisplayPlanePropertiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkDisplayPlanePropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.calloc(capacity, stack);
    }

    public static VkDisplayPlanePropertiesKHR malloc(MemoryStack stack) {
        return new VkDisplayPlanePropertiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDisplayPlanePropertiesKHR calloc(MemoryStack stack) {
        return new VkDisplayPlanePropertiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncurrentDisplay(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CURRENTDISPLAY);
    }

    public static int ncurrentStackIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTSTACKINDEX);
    }

    static {
        Struct.Layout layout = VkDisplayPlanePropertiesKHR.__struct(VkDisplayPlanePropertiesKHR.__member(8), VkDisplayPlanePropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURRENTDISPLAY = layout.offsetof(0);
        CURRENTSTACKINDEX = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDisplayPlanePropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkDisplayPlanePropertiesKHR ELEMENT_FACTORY = VkDisplayPlanePropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkDisplayPlanePropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDisplayKHR")
        public long currentDisplay() {
            return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
        }

        @NativeType(value="uint32_t")
        public int currentStackIndex() {
            return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
        }
    }
}

