/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryImageCreateInfo
extends Struct<VkExternalMemoryImageCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    protected VkExternalMemoryImageCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExternalMemoryImageCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkExternalMemoryImageCreateInfo(address, container);
    }

    public VkExternalMemoryImageCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalMemoryImageCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryImageCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryImageCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlags")
    public int handleTypes() {
        return VkExternalMemoryImageCreateInfo.nhandleTypes(this.address());
    }

    public VkExternalMemoryImageCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo sType$Default() {
        return this.sType(1000072001);
    }

    public VkExternalMemoryImageCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
        VkExternalMemoryImageCreateInfo.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfo set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfo set(VkExternalMemoryImageCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfo malloc() {
        return new VkExternalMemoryImageCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfo calloc() {
        return new VkExternalMemoryImageCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExternalMemoryImageCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkExternalMemoryImageCreateInfo create(long address) {
        return new VkExternalMemoryImageCreateInfo(address, null);
    }

    public static @Nullable VkExternalMemoryImageCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkExternalMemoryImageCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExternalMemoryImageCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryImageCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfo mallocStack() {
        return VkExternalMemoryImageCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfo callocStack() {
        return VkExternalMemoryImageCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfo mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfo callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfo.calloc(capacity, stack);
    }

    public static VkExternalMemoryImageCreateInfo malloc(MemoryStack stack) {
        return new VkExternalMemoryImageCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfo calloc(MemoryStack stack) {
        return new VkExternalMemoryImageCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryImageCreateInfo.__struct(VkExternalMemoryImageCreateInfo.__member(4), VkExternalMemoryImageCreateInfo.__member(POINTER_SIZE), VkExternalMemoryImageCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryImageCreateInfo, Buffer>
    implements NativeResource {
        private static final VkExternalMemoryImageCreateInfo ELEMENT_FACTORY = VkExternalMemoryImageCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkExternalMemoryImageCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryImageCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryImageCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlags")
        public int handleTypes() {
            return VkExternalMemoryImageCreateInfo.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000072001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlags") int value) {
            VkExternalMemoryImageCreateInfo.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

