/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkExternalMemoryImageCreateInfoNV
extends Struct<VkExternalMemoryImageCreateInfoNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPES;

    protected VkExternalMemoryImageCreateInfoNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExternalMemoryImageCreateInfoNV create(long address, @Nullable ByteBuffer container) {
        return new VkExternalMemoryImageCreateInfoNV(address, container);
    }

    public VkExternalMemoryImageCreateInfoNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExternalMemoryImageCreateInfoNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExternalMemoryImageCreateInfoNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExternalMemoryImageCreateInfoNV.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
    public int handleTypes() {
        return VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address());
    }

    public VkExternalMemoryImageCreateInfoNV sType(@NativeType(value="VkStructureType") int value) {
        VkExternalMemoryImageCreateInfoNV.nsType(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV sType$Default() {
        return this.sType(1000056000);
    }

    public VkExternalMemoryImageCreateInfoNV pNext(@NativeType(value="void const *") long value) {
        VkExternalMemoryImageCreateInfoNV.npNext(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
        VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address(), value);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV set(int sType, long pNext, int handleTypes) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleTypes(handleTypes);
        return this;
    }

    public VkExternalMemoryImageCreateInfoNV set(VkExternalMemoryImageCreateInfoNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExternalMemoryImageCreateInfoNV malloc() {
        return new VkExternalMemoryImageCreateInfoNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfoNV calloc() {
        return new VkExternalMemoryImageCreateInfoNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfoNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExternalMemoryImageCreateInfoNV(MemoryUtil.memAddress(container), container);
    }

    public static VkExternalMemoryImageCreateInfoNV create(long address) {
        return new VkExternalMemoryImageCreateInfoNV(address, null);
    }

    public static @Nullable VkExternalMemoryImageCreateInfoNV createSafe(long address) {
        return address == 0L ? null : new VkExternalMemoryImageCreateInfoNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExternalMemoryImageCreateInfoNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExternalMemoryImageCreateInfoNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoNV mallocStack() {
        return VkExternalMemoryImageCreateInfoNV.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoNV callocStack() {
        return VkExternalMemoryImageCreateInfoNV.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoNV mallocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.malloc(stack);
    }

    @Deprecated
    public static VkExternalMemoryImageCreateInfoNV callocStack(MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExternalMemoryImageCreateInfoNV.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExternalMemoryImageCreateInfoNV.calloc(capacity, stack);
    }

    public static VkExternalMemoryImageCreateInfoNV malloc(MemoryStack stack) {
        return new VkExternalMemoryImageCreateInfoNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExternalMemoryImageCreateInfoNV calloc(MemoryStack stack) {
        return new VkExternalMemoryImageCreateInfoNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleTypes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HANDLETYPES);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleTypes(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)HANDLETYPES, value);
    }

    static {
        Struct.Layout layout = VkExternalMemoryImageCreateInfoNV.__struct(VkExternalMemoryImageCreateInfoNV.__member(4), VkExternalMemoryImageCreateInfoNV.__member(POINTER_SIZE), VkExternalMemoryImageCreateInfoNV.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPES = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkExternalMemoryImageCreateInfoNV, Buffer>
    implements NativeResource {
        private static final VkExternalMemoryImageCreateInfoNV ELEMENT_FACTORY = VkExternalMemoryImageCreateInfoNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkExternalMemoryImageCreateInfoNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExternalMemoryImageCreateInfoNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExternalMemoryImageCreateInfoNV.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagsNV")
        public int handleTypes() {
            return VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExternalMemoryImageCreateInfoNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000056000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExternalMemoryImageCreateInfoNV.npNext(this.address(), value);
            return this;
        }

        public Buffer handleTypes(@NativeType(value="VkExternalMemoryHandleTypeFlagsNV") int value) {
            VkExternalMemoryImageCreateInfoNV.nhandleTypes(this.address(), value);
            return this;
        }
    }
}

