/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageSubresourceRange;

public class VkHostImageLayoutTransitionInfo
extends Struct<VkHostImageLayoutTransitionInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int IMAGE;
    public static final int OLDLAYOUT;
    public static final int NEWLAYOUT;
    public static final int SUBRESOURCERANGE;

    protected VkHostImageLayoutTransitionInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkHostImageLayoutTransitionInfo create(long address, @Nullable ByteBuffer container) {
        return new VkHostImageLayoutTransitionInfo(address, container);
    }

    public VkHostImageLayoutTransitionInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkHostImageLayoutTransitionInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkHostImageLayoutTransitionInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkHostImageLayoutTransitionInfo.npNext(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkHostImageLayoutTransitionInfo.nimage(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int oldLayout() {
        return VkHostImageLayoutTransitionInfo.noldLayout(this.address());
    }

    @NativeType(value="VkImageLayout")
    public int newLayout() {
        return VkHostImageLayoutTransitionInfo.nnewLayout(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkHostImageLayoutTransitionInfo.nsubresourceRange(this.address());
    }

    public VkHostImageLayoutTransitionInfo sType(@NativeType(value="VkStructureType") int value) {
        VkHostImageLayoutTransitionInfo.nsType(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo sType$Default() {
        return this.sType(1000270006);
    }

    public VkHostImageLayoutTransitionInfo pNext(@NativeType(value="void const *") long value) {
        VkHostImageLayoutTransitionInfo.npNext(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo image(@NativeType(value="VkImage") long value) {
        VkHostImageLayoutTransitionInfo.nimage(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo oldLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfo.noldLayout(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo newLayout(@NativeType(value="VkImageLayout") int value) {
        VkHostImageLayoutTransitionInfo.nnewLayout(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo subresourceRange(VkImageSubresourceRange value) {
        VkHostImageLayoutTransitionInfo.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkHostImageLayoutTransitionInfo subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    public VkHostImageLayoutTransitionInfo set(int sType, long pNext, long image, int oldLayout, int newLayout, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.image(image);
        this.oldLayout(oldLayout);
        this.newLayout(newLayout);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkHostImageLayoutTransitionInfo set(VkHostImageLayoutTransitionInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkHostImageLayoutTransitionInfo malloc() {
        return new VkHostImageLayoutTransitionInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfo calloc() {
        return new VkHostImageLayoutTransitionInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkHostImageLayoutTransitionInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkHostImageLayoutTransitionInfo create(long address) {
        return new VkHostImageLayoutTransitionInfo(address, null);
    }

    public static @Nullable VkHostImageLayoutTransitionInfo createSafe(long address) {
        return address == 0L ? null : new VkHostImageLayoutTransitionInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkHostImageLayoutTransitionInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkHostImageLayoutTransitionInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkHostImageLayoutTransitionInfo malloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkHostImageLayoutTransitionInfo calloc(MemoryStack stack) {
        return new VkHostImageLayoutTransitionInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int noldLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OLDLAYOUT);
    }

    public static int nnewLayout(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NEWLAYOUT);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void noldLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OLDLAYOUT, value);
    }

    public static void nnewLayout(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)NEWLAYOUT, value);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkHostImageLayoutTransitionInfo.__struct(VkHostImageLayoutTransitionInfo.__member(4), VkHostImageLayoutTransitionInfo.__member(POINTER_SIZE), VkHostImageLayoutTransitionInfo.__member(8), VkHostImageLayoutTransitionInfo.__member(4), VkHostImageLayoutTransitionInfo.__member(4), VkHostImageLayoutTransitionInfo.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        IMAGE = layout.offsetof(2);
        OLDLAYOUT = layout.offsetof(3);
        NEWLAYOUT = layout.offsetof(4);
        SUBRESOURCERANGE = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkHostImageLayoutTransitionInfo, Buffer>
    implements NativeResource {
        private static final VkHostImageLayoutTransitionInfo ELEMENT_FACTORY = VkHostImageLayoutTransitionInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkHostImageLayoutTransitionInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkHostImageLayoutTransitionInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkHostImageLayoutTransitionInfo.npNext(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkHostImageLayoutTransitionInfo.nimage(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int oldLayout() {
            return VkHostImageLayoutTransitionInfo.noldLayout(this.address());
        }

        @NativeType(value="VkImageLayout")
        public int newLayout() {
            return VkHostImageLayoutTransitionInfo.nnewLayout(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkHostImageLayoutTransitionInfo.nsubresourceRange(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkHostImageLayoutTransitionInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270006);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkHostImageLayoutTransitionInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkHostImageLayoutTransitionInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer oldLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfo.noldLayout(this.address(), value);
            return this;
        }

        public Buffer newLayout(@NativeType(value="VkImageLayout") int value) {
            VkHostImageLayoutTransitionInfo.nnewLayout(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkHostImageLayoutTransitionInfo.nsubresourceRange(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }
    }
}

