/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkImageToMemoryCopy;
import org.lwjgl.vulkan.VkOffset3D;

public class VkImageToMemoryCopyEXT
extends VkImageToMemoryCopy {
    protected VkImageToMemoryCopyEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageToMemoryCopyEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImageToMemoryCopyEXT(address, container);
    }

    public VkImageToMemoryCopyEXT(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkImageToMemoryCopyEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImageToMemoryCopyEXT.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT sType$Default() {
        return this.sType(1000270003);
    }

    @Override
    public VkImageToMemoryCopyEXT pNext(@NativeType(value="void const *") long value) {
        VkImageToMemoryCopyEXT.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT pHostPointer(@NativeType(value="void *") long value) {
        VkImageToMemoryCopyEXT.npHostPointer(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT memoryRowLength(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopyEXT.nmemoryRowLength(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT memoryImageHeight(@NativeType(value="uint32_t") int value) {
        VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageSubresource(VkImageSubresourceLayers value) {
        VkImageToMemoryCopyEXT.nimageSubresource(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageOffset(VkOffset3D value) {
        VkImageToMemoryCopyEXT.nimageOffset(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageExtent(VkExtent3D value) {
        VkImageToMemoryCopyEXT.nimageExtent(this.address(), value);
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    @Override
    public VkImageToMemoryCopyEXT set(int sType, long pNext, long pHostPointer, int memoryRowLength, int memoryImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.pHostPointer(pHostPointer);
        this.memoryRowLength(memoryRowLength);
        this.memoryImageHeight(memoryImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkImageToMemoryCopyEXT set(VkImageToMemoryCopyEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageToMemoryCopyEXT malloc() {
        return new VkImageToMemoryCopyEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT calloc() {
        return new VkImageToMemoryCopyEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageToMemoryCopyEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkImageToMemoryCopyEXT create(long address) {
        return new VkImageToMemoryCopyEXT(address, null);
    }

    public static @Nullable VkImageToMemoryCopyEXT createSafe(long address) {
        return address == 0L ? null : new VkImageToMemoryCopyEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageToMemoryCopyEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageToMemoryCopyEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkImageToMemoryCopyEXT malloc(MemoryStack stack) {
        return new VkImageToMemoryCopyEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageToMemoryCopyEXT calloc(MemoryStack stack) {
        return new VkImageToMemoryCopyEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkImageToMemoryCopy.Buffer {
        private static final VkImageToMemoryCopyEXT ELEMENT_FACTORY = VkImageToMemoryCopyEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageToMemoryCopyEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageToMemoryCopyEXT.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000270003);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageToMemoryCopyEXT.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer pHostPointer(@NativeType(value="void *") long value) {
            VkImageToMemoryCopyEXT.npHostPointer(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryRowLength(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopyEXT.nmemoryRowLength(this.address(), value);
            return this;
        }

        @Override
        public Buffer memoryImageHeight(@NativeType(value="uint32_t") int value) {
            VkImageToMemoryCopyEXT.nmemoryImageHeight(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkImageToMemoryCopyEXT.nimageSubresource(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        @Override
        public Buffer imageOffset(VkOffset3D value) {
            VkImageToMemoryCopyEXT.nimageOffset(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        @Override
        public Buffer imageExtent(VkExtent3D value) {
            VkImageToMemoryCopyEXT.nimageExtent(this.address(), value);
            return this;
        }

        @Override
        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

