/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkComponentMapping;
import org.lwjgl.vulkan.VkExportMetalObjectCreateInfoEXT;
import org.lwjgl.vulkan.VkImageSubresourceRange;
import org.lwjgl.vulkan.VkImageViewASTCDecodeModeEXT;
import org.lwjgl.vulkan.VkImageViewMinLodCreateInfoEXT;
import org.lwjgl.vulkan.VkImageViewSampleWeightCreateInfoQCOM;
import org.lwjgl.vulkan.VkImageViewSlicedCreateInfoEXT;
import org.lwjgl.vulkan.VkImageViewUsageCreateInfo;
import org.lwjgl.vulkan.VkImageViewUsageCreateInfoKHR;
import org.lwjgl.vulkan.VkOpaqueCaptureDescriptorDataCreateInfoEXT;
import org.lwjgl.vulkan.VkSamplerYcbcrConversionInfo;
import org.lwjgl.vulkan.VkSamplerYcbcrConversionInfoKHR;

public class VkImageViewCreateInfo
extends Struct<VkImageViewCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int IMAGE;
    public static final int VIEWTYPE;
    public static final int FORMAT;
    public static final int COMPONENTS;
    public static final int SUBRESOURCERANGE;

    protected VkImageViewCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImageViewCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkImageViewCreateInfo(address, container);
    }

    public VkImageViewCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImageViewCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImageViewCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImageViewCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkImageViewCreateFlags")
    public int flags() {
        return VkImageViewCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkImage")
    public long image() {
        return VkImageViewCreateInfo.nimage(this.address());
    }

    @NativeType(value="VkImageViewType")
    public int viewType() {
        return VkImageViewCreateInfo.nviewType(this.address());
    }

    @NativeType(value="VkFormat")
    public int format() {
        return VkImageViewCreateInfo.nformat(this.address());
    }

    public VkComponentMapping components() {
        return VkImageViewCreateInfo.ncomponents(this.address());
    }

    public VkImageSubresourceRange subresourceRange() {
        return VkImageViewCreateInfo.nsubresourceRange(this.address());
    }

    public VkImageViewCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkImageViewCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo sType$Default() {
        return this.sType(15);
    }

    public VkImageViewCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkImageViewCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo pNext(VkExportMetalObjectCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewASTCDecodeModeEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewMinLodCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewSampleWeightCreateInfoQCOM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewSlicedCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewUsageCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkImageViewUsageCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkSamplerYcbcrConversionInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo pNext(VkSamplerYcbcrConversionInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkImageViewCreateInfo flags(@NativeType(value="VkImageViewCreateFlags") int value) {
        VkImageViewCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo image(@NativeType(value="VkImage") long value) {
        VkImageViewCreateInfo.nimage(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo viewType(@NativeType(value="VkImageViewType") int value) {
        VkImageViewCreateInfo.nviewType(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo format(@NativeType(value="VkFormat") int value) {
        VkImageViewCreateInfo.nformat(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo components(VkComponentMapping value) {
        VkImageViewCreateInfo.ncomponents(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo components(Consumer<VkComponentMapping> consumer) {
        consumer.accept(this.components());
        return this;
    }

    public VkImageViewCreateInfo subresourceRange(VkImageSubresourceRange value) {
        VkImageViewCreateInfo.nsubresourceRange(this.address(), value);
        return this;
    }

    public VkImageViewCreateInfo subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
        consumer.accept(this.subresourceRange());
        return this;
    }

    public VkImageViewCreateInfo set(int sType, long pNext, int flags, long image, int viewType, int format, VkComponentMapping components, VkImageSubresourceRange subresourceRange) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.image(image);
        this.viewType(viewType);
        this.format(format);
        this.components(components);
        this.subresourceRange(subresourceRange);
        return this;
    }

    public VkImageViewCreateInfo set(VkImageViewCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImageViewCreateInfo malloc() {
        return new VkImageViewCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImageViewCreateInfo calloc() {
        return new VkImageViewCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImageViewCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImageViewCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkImageViewCreateInfo create(long address) {
        return new VkImageViewCreateInfo(address, null);
    }

    public static @Nullable VkImageViewCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkImageViewCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImageViewCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImageViewCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImageViewCreateInfo mallocStack() {
        return VkImageViewCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewCreateInfo callocStack() {
        return VkImageViewCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImageViewCreateInfo mallocStack(MemoryStack stack) {
        return VkImageViewCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkImageViewCreateInfo callocStack(MemoryStack stack) {
        return VkImageViewCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImageViewCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImageViewCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImageViewCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImageViewCreateInfo.calloc(capacity, stack);
    }

    public static VkImageViewCreateInfo malloc(MemoryStack stack) {
        return new VkImageViewCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImageViewCreateInfo calloc(MemoryStack stack) {
        return new VkImageViewCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nimage(long struct) {
        return MemoryUtil.memGetLong(struct + (long)IMAGE);
    }

    public static int nviewType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIEWTYPE);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static VkComponentMapping ncomponents(long struct) {
        return VkComponentMapping.create(struct + (long)COMPONENTS);
    }

    public static VkImageSubresourceRange nsubresourceRange(long struct) {
        return VkImageSubresourceRange.create(struct + (long)SUBRESOURCERANGE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nimage(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)IMAGE, value);
    }

    public static void nviewType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIEWTYPE, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    public static void ncomponents(long struct, VkComponentMapping value) {
        MemoryUtil.memCopy(value.address(), struct + (long)COMPONENTS, VkComponentMapping.SIZEOF);
    }

    public static void nsubresourceRange(long struct, VkImageSubresourceRange value) {
        MemoryUtil.memCopy(value.address(), struct + (long)SUBRESOURCERANGE, VkImageSubresourceRange.SIZEOF);
    }

    static {
        Struct.Layout layout = VkImageViewCreateInfo.__struct(VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(POINTER_SIZE), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(8), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(4), VkImageViewCreateInfo.__member(VkComponentMapping.SIZEOF, VkComponentMapping.ALIGNOF), VkImageViewCreateInfo.__member(VkImageSubresourceRange.SIZEOF, VkImageSubresourceRange.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        IMAGE = layout.offsetof(3);
        VIEWTYPE = layout.offsetof(4);
        FORMAT = layout.offsetof(5);
        COMPONENTS = layout.offsetof(6);
        SUBRESOURCERANGE = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkImageViewCreateInfo, Buffer>
    implements NativeResource {
        private static final VkImageViewCreateInfo ELEMENT_FACTORY = VkImageViewCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkImageViewCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImageViewCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImageViewCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkImageViewCreateFlags")
        public int flags() {
            return VkImageViewCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkImage")
        public long image() {
            return VkImageViewCreateInfo.nimage(this.address());
        }

        @NativeType(value="VkImageViewType")
        public int viewType() {
            return VkImageViewCreateInfo.nviewType(this.address());
        }

        @NativeType(value="VkFormat")
        public int format() {
            return VkImageViewCreateInfo.nformat(this.address());
        }

        public VkComponentMapping components() {
            return VkImageViewCreateInfo.ncomponents(this.address());
        }

        public VkImageSubresourceRange subresourceRange() {
            return VkImageViewCreateInfo.nsubresourceRange(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImageViewCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(15);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImageViewCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkExportMetalObjectCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewASTCDecodeModeEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewMinLodCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewSampleWeightCreateInfoQCOM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewSlicedCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewUsageCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkImageViewUsageCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkOpaqueCaptureDescriptorDataCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSamplerYcbcrConversionInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkSamplerYcbcrConversionInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkImageViewCreateFlags") int value) {
            VkImageViewCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer image(@NativeType(value="VkImage") long value) {
            VkImageViewCreateInfo.nimage(this.address(), value);
            return this;
        }

        public Buffer viewType(@NativeType(value="VkImageViewType") int value) {
            VkImageViewCreateInfo.nviewType(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="VkFormat") int value) {
            VkImageViewCreateInfo.nformat(this.address(), value);
            return this;
        }

        public Buffer components(VkComponentMapping value) {
            VkImageViewCreateInfo.ncomponents(this.address(), value);
            return this;
        }

        public Buffer components(Consumer<VkComponentMapping> consumer) {
            consumer.accept(this.components());
            return this;
        }

        public Buffer subresourceRange(VkImageSubresourceRange value) {
            VkImageViewCreateInfo.nsubresourceRange(this.address(), value);
            return this;
        }

        public Buffer subresourceRange(Consumer<VkImageSubresourceRange> consumer) {
            consumer.accept(this.subresourceRange());
            return this;
        }
    }
}

