/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkIndirectCommandsLayoutTokenNV
extends Struct<VkIndirectCommandsLayoutTokenNV>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int TOKENTYPE;
    public static final int STREAM;
    public static final int OFFSET;
    public static final int VERTEXBINDINGUNIT;
    public static final int VERTEXDYNAMICSTRIDE;
    public static final int PUSHCONSTANTPIPELINELAYOUT;
    public static final int PUSHCONSTANTSHADERSTAGEFLAGS;
    public static final int PUSHCONSTANTOFFSET;
    public static final int PUSHCONSTANTSIZE;
    public static final int INDIRECTSTATEFLAGS;
    public static final int INDEXTYPECOUNT;
    public static final int PINDEXTYPES;
    public static final int PINDEXTYPEVALUES;

    protected VkIndirectCommandsLayoutTokenNV(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkIndirectCommandsLayoutTokenNV create(long address, @Nullable ByteBuffer container) {
        return new VkIndirectCommandsLayoutTokenNV(address, container);
    }

    public VkIndirectCommandsLayoutTokenNV(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkIndirectCommandsLayoutTokenNV.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectCommandsLayoutTokenNV.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectCommandsLayoutTokenNV.npNext(this.address());
    }

    @NativeType(value="VkIndirectCommandsTokenTypeNV")
    public int tokenType() {
        return VkIndirectCommandsLayoutTokenNV.ntokenType(this.address());
    }

    @NativeType(value="uint32_t")
    public int stream$() {
        return VkIndirectCommandsLayoutTokenNV.nstream$(this.address());
    }

    @NativeType(value="uint32_t")
    public int offset() {
        return VkIndirectCommandsLayoutTokenNV.noffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int vertexBindingUnit() {
        return VkIndirectCommandsLayoutTokenNV.nvertexBindingUnit(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean vertexDynamicStride() {
        return VkIndirectCommandsLayoutTokenNV.nvertexDynamicStride(this.address()) != 0;
    }

    @NativeType(value="VkPipelineLayout")
    public long pushconstantPipelineLayout() {
        return VkIndirectCommandsLayoutTokenNV.npushconstantPipelineLayout(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int pushconstantShaderStageFlags() {
        return VkIndirectCommandsLayoutTokenNV.npushconstantShaderStageFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int pushconstantOffset() {
        return VkIndirectCommandsLayoutTokenNV.npushconstantOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int pushconstantSize() {
        return VkIndirectCommandsLayoutTokenNV.npushconstantSize(this.address());
    }

    @NativeType(value="VkIndirectStateFlagsNV")
    public int indirectStateFlags() {
        return VkIndirectCommandsLayoutTokenNV.nindirectStateFlags(this.address());
    }

    @NativeType(value="uint32_t")
    public int indexTypeCount() {
        return VkIndirectCommandsLayoutTokenNV.nindexTypeCount(this.address());
    }

    @NativeType(value="VkIndexType const *")
    public @Nullable IntBuffer pIndexTypes() {
        return VkIndirectCommandsLayoutTokenNV.npIndexTypes(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pIndexTypeValues() {
        return VkIndirectCommandsLayoutTokenNV.npIndexTypeValues(this.address());
    }

    public VkIndirectCommandsLayoutTokenNV sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectCommandsLayoutTokenNV.nsType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV sType$Default() {
        return this.sType(1000277003);
    }

    public VkIndirectCommandsLayoutTokenNV pNext(@NativeType(value="void const *") long value) {
        VkIndirectCommandsLayoutTokenNV.npNext(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNV") int value) {
        VkIndirectCommandsLayoutTokenNV.ntokenType(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV stream$(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.nstream$(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV offset(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.noffset(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV vertexBindingUnit(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.nvertexBindingUnit(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV vertexDynamicStride(@NativeType(value="VkBool32") boolean value) {
        VkIndirectCommandsLayoutTokenNV.nvertexDynamicStride(this.address(), value ? 1 : 0);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pushconstantPipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
        VkIndirectCommandsLayoutTokenNV.npushconstantPipelineLayout(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pushconstantShaderStageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkIndirectCommandsLayoutTokenNV.npushconstantShaderStageFlags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pushconstantOffset(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.npushconstantOffset(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pushconstantSize(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.npushconstantSize(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV indirectStateFlags(@NativeType(value="VkIndirectStateFlagsNV") int value) {
        VkIndirectCommandsLayoutTokenNV.nindirectStateFlags(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV indexTypeCount(@NativeType(value="uint32_t") int value) {
        VkIndirectCommandsLayoutTokenNV.nindexTypeCount(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pIndexTypes(@NativeType(value="VkIndexType const *") @Nullable IntBuffer value) {
        VkIndirectCommandsLayoutTokenNV.npIndexTypes(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV pIndexTypeValues(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkIndirectCommandsLayoutTokenNV.npIndexTypeValues(this.address(), value);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV set(int sType, long pNext, int tokenType, int stream$, int offset, int vertexBindingUnit, boolean vertexDynamicStride, long pushconstantPipelineLayout, int pushconstantShaderStageFlags, int pushconstantOffset, int pushconstantSize, int indirectStateFlags, int indexTypeCount, @Nullable IntBuffer pIndexTypes, @Nullable IntBuffer pIndexTypeValues) {
        this.sType(sType);
        this.pNext(pNext);
        this.tokenType(tokenType);
        this.stream$(stream$);
        this.offset(offset);
        this.vertexBindingUnit(vertexBindingUnit);
        this.vertexDynamicStride(vertexDynamicStride);
        this.pushconstantPipelineLayout(pushconstantPipelineLayout);
        this.pushconstantShaderStageFlags(pushconstantShaderStageFlags);
        this.pushconstantOffset(pushconstantOffset);
        this.pushconstantSize(pushconstantSize);
        this.indirectStateFlags(indirectStateFlags);
        this.indexTypeCount(indexTypeCount);
        this.pIndexTypes(pIndexTypes);
        this.pIndexTypeValues(pIndexTypeValues);
        return this;
    }

    public VkIndirectCommandsLayoutTokenNV set(VkIndirectCommandsLayoutTokenNV src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectCommandsLayoutTokenNV malloc() {
        return new VkIndirectCommandsLayoutTokenNV(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutTokenNV calloc() {
        return new VkIndirectCommandsLayoutTokenNV(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutTokenNV create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkIndirectCommandsLayoutTokenNV(MemoryUtil.memAddress(container), container);
    }

    public static VkIndirectCommandsLayoutTokenNV create(long address) {
        return new VkIndirectCommandsLayoutTokenNV(address, null);
    }

    public static @Nullable VkIndirectCommandsLayoutTokenNV createSafe(long address) {
        return address == 0L ? null : new VkIndirectCommandsLayoutTokenNV(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkIndirectCommandsLayoutTokenNV.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectCommandsLayoutTokenNV.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkIndirectCommandsLayoutTokenNV malloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutTokenNV(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkIndirectCommandsLayoutTokenNV calloc(MemoryStack stack) {
        return new VkIndirectCommandsLayoutTokenNV(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ntokenType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TOKENTYPE);
    }

    public static int nstream$(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STREAM);
    }

    public static int noffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)OFFSET);
    }

    public static int nvertexBindingUnit(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXBINDINGUNIT);
    }

    public static int nvertexDynamicStride(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VERTEXDYNAMICSTRIDE);
    }

    public static long npushconstantPipelineLayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PUSHCONSTANTPIPELINELAYOUT);
    }

    public static int npushconstantShaderStageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PUSHCONSTANTSHADERSTAGEFLAGS);
    }

    public static int npushconstantOffset(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PUSHCONSTANTOFFSET);
    }

    public static int npushconstantSize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PUSHCONSTANTSIZE);
    }

    public static int nindirectStateFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDIRECTSTATEFLAGS);
    }

    public static int nindexTypeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INDEXTYPECOUNT);
    }

    public static @Nullable IntBuffer npIndexTypes(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PINDEXTYPES), VkIndirectCommandsLayoutTokenNV.nindexTypeCount(struct));
    }

    public static @Nullable IntBuffer npIndexTypeValues(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PINDEXTYPEVALUES), VkIndirectCommandsLayoutTokenNV.nindexTypeCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ntokenType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)TOKENTYPE, value);
    }

    public static void nstream$(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STREAM, value);
    }

    public static void noffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)OFFSET, value);
    }

    public static void nvertexBindingUnit(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXBINDINGUNIT, value);
    }

    public static void nvertexDynamicStride(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VERTEXDYNAMICSTRIDE, value);
    }

    public static void npushconstantPipelineLayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PUSHCONSTANTPIPELINELAYOUT, value);
    }

    public static void npushconstantShaderStageFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PUSHCONSTANTSHADERSTAGEFLAGS, value);
    }

    public static void npushconstantOffset(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PUSHCONSTANTOFFSET, value);
    }

    public static void npushconstantSize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PUSHCONSTANTSIZE, value);
    }

    public static void nindirectStateFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDIRECTSTATEFLAGS, value);
    }

    public static void nindexTypeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INDEXTYPECOUNT, value);
    }

    public static void npIndexTypes(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINDEXTYPES, MemoryUtil.memAddressSafe(value));
    }

    public static void npIndexTypeValues(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINDEXTYPEVALUES, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        if (VkIndirectCommandsLayoutTokenNV.nindexTypeCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINDEXTYPES));
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PINDEXTYPEVALUES));
        }
    }

    static {
        Struct.Layout layout = VkIndirectCommandsLayoutTokenNV.__struct(VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(POINTER_SIZE), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(8), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(4), VkIndirectCommandsLayoutTokenNV.__member(POINTER_SIZE), VkIndirectCommandsLayoutTokenNV.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        TOKENTYPE = layout.offsetof(2);
        STREAM = layout.offsetof(3);
        OFFSET = layout.offsetof(4);
        VERTEXBINDINGUNIT = layout.offsetof(5);
        VERTEXDYNAMICSTRIDE = layout.offsetof(6);
        PUSHCONSTANTPIPELINELAYOUT = layout.offsetof(7);
        PUSHCONSTANTSHADERSTAGEFLAGS = layout.offsetof(8);
        PUSHCONSTANTOFFSET = layout.offsetof(9);
        PUSHCONSTANTSIZE = layout.offsetof(10);
        INDIRECTSTATEFLAGS = layout.offsetof(11);
        INDEXTYPECOUNT = layout.offsetof(12);
        PINDEXTYPES = layout.offsetof(13);
        PINDEXTYPEVALUES = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectCommandsLayoutTokenNV, Buffer>
    implements NativeResource {
        private static final VkIndirectCommandsLayoutTokenNV ELEMENT_FACTORY = VkIndirectCommandsLayoutTokenNV.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkIndirectCommandsLayoutTokenNV getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectCommandsLayoutTokenNV.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectCommandsLayoutTokenNV.npNext(this.address());
        }

        @NativeType(value="VkIndirectCommandsTokenTypeNV")
        public int tokenType() {
            return VkIndirectCommandsLayoutTokenNV.ntokenType(this.address());
        }

        @NativeType(value="uint32_t")
        public int stream$() {
            return VkIndirectCommandsLayoutTokenNV.nstream$(this.address());
        }

        @NativeType(value="uint32_t")
        public int offset() {
            return VkIndirectCommandsLayoutTokenNV.noffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int vertexBindingUnit() {
            return VkIndirectCommandsLayoutTokenNV.nvertexBindingUnit(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean vertexDynamicStride() {
            return VkIndirectCommandsLayoutTokenNV.nvertexDynamicStride(this.address()) != 0;
        }

        @NativeType(value="VkPipelineLayout")
        public long pushconstantPipelineLayout() {
            return VkIndirectCommandsLayoutTokenNV.npushconstantPipelineLayout(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int pushconstantShaderStageFlags() {
            return VkIndirectCommandsLayoutTokenNV.npushconstantShaderStageFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int pushconstantOffset() {
            return VkIndirectCommandsLayoutTokenNV.npushconstantOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int pushconstantSize() {
            return VkIndirectCommandsLayoutTokenNV.npushconstantSize(this.address());
        }

        @NativeType(value="VkIndirectStateFlagsNV")
        public int indirectStateFlags() {
            return VkIndirectCommandsLayoutTokenNV.nindirectStateFlags(this.address());
        }

        @NativeType(value="uint32_t")
        public int indexTypeCount() {
            return VkIndirectCommandsLayoutTokenNV.nindexTypeCount(this.address());
        }

        @NativeType(value="VkIndexType const *")
        public @Nullable IntBuffer pIndexTypes() {
            return VkIndirectCommandsLayoutTokenNV.npIndexTypes(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pIndexTypeValues() {
            return VkIndirectCommandsLayoutTokenNV.npIndexTypeValues(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectCommandsLayoutTokenNV.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000277003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectCommandsLayoutTokenNV.npNext(this.address(), value);
            return this;
        }

        public Buffer tokenType(@NativeType(value="VkIndirectCommandsTokenTypeNV") int value) {
            VkIndirectCommandsLayoutTokenNV.ntokenType(this.address(), value);
            return this;
        }

        public Buffer stream$(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.nstream$(this.address(), value);
            return this;
        }

        public Buffer offset(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.noffset(this.address(), value);
            return this;
        }

        public Buffer vertexBindingUnit(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.nvertexBindingUnit(this.address(), value);
            return this;
        }

        public Buffer vertexDynamicStride(@NativeType(value="VkBool32") boolean value) {
            VkIndirectCommandsLayoutTokenNV.nvertexDynamicStride(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer pushconstantPipelineLayout(@NativeType(value="VkPipelineLayout") long value) {
            VkIndirectCommandsLayoutTokenNV.npushconstantPipelineLayout(this.address(), value);
            return this;
        }

        public Buffer pushconstantShaderStageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkIndirectCommandsLayoutTokenNV.npushconstantShaderStageFlags(this.address(), value);
            return this;
        }

        public Buffer pushconstantOffset(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.npushconstantOffset(this.address(), value);
            return this;
        }

        public Buffer pushconstantSize(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.npushconstantSize(this.address(), value);
            return this;
        }

        public Buffer indirectStateFlags(@NativeType(value="VkIndirectStateFlagsNV") int value) {
            VkIndirectCommandsLayoutTokenNV.nindirectStateFlags(this.address(), value);
            return this;
        }

        public Buffer indexTypeCount(@NativeType(value="uint32_t") int value) {
            VkIndirectCommandsLayoutTokenNV.nindexTypeCount(this.address(), value);
            return this;
        }

        public Buffer pIndexTypes(@NativeType(value="VkIndexType const *") @Nullable IntBuffer value) {
            VkIndirectCommandsLayoutTokenNV.npIndexTypes(this.address(), value);
            return this;
        }

        public Buffer pIndexTypeValues(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkIndirectCommandsLayoutTokenNV.npIndexTypeValues(this.address(), value);
            return this;
        }
    }
}

