/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkIndirectExecutionSetShaderLayoutInfoEXT;
import org.lwjgl.vulkan.VkPushConstantRange;

public class VkIndirectExecutionSetShaderInfoEXT
extends Struct<VkIndirectExecutionSetShaderInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SHADERCOUNT;
    public static final int PINITIALSHADERS;
    public static final int PSETLAYOUTINFOS;
    public static final int MAXSHADERCOUNT;
    public static final int PUSHCONSTANTRANGECOUNT;
    public static final int PPUSHCONSTANTRANGES;

    protected VkIndirectExecutionSetShaderInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkIndirectExecutionSetShaderInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkIndirectExecutionSetShaderInfoEXT(address, container);
    }

    public VkIndirectExecutionSetShaderInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkIndirectExecutionSetShaderInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkIndirectExecutionSetShaderInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkIndirectExecutionSetShaderInfoEXT.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int shaderCount() {
        return VkIndirectExecutionSetShaderInfoEXT.nshaderCount(this.address());
    }

    @NativeType(value="VkShaderEXT const *")
    public LongBuffer pInitialShaders() {
        return VkIndirectExecutionSetShaderInfoEXT.npInitialShaders(this.address());
    }

    @NativeType(value="VkIndirectExecutionSetShaderLayoutInfoEXT const *")
    public @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer pSetLayoutInfos() {
        return VkIndirectExecutionSetShaderInfoEXT.npSetLayoutInfos(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxShaderCount() {
        return VkIndirectExecutionSetShaderInfoEXT.nmaxShaderCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int pushConstantRangeCount() {
        return VkIndirectExecutionSetShaderInfoEXT.npushConstantRangeCount(this.address());
    }

    @NativeType(value="VkPushConstantRange const *")
    public @Nullable VkPushConstantRange.Buffer pPushConstantRanges() {
        return VkIndirectExecutionSetShaderInfoEXT.npPushConstantRanges(this.address());
    }

    public VkIndirectExecutionSetShaderInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkIndirectExecutionSetShaderInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT sType$Default() {
        return this.sType(1000572011);
    }

    public VkIndirectExecutionSetShaderInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkIndirectExecutionSetShaderInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT shaderCount(@NativeType(value="uint32_t") int value) {
        VkIndirectExecutionSetShaderInfoEXT.nshaderCount(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT pInitialShaders(@NativeType(value="VkShaderEXT const *") LongBuffer value) {
        VkIndirectExecutionSetShaderInfoEXT.npInitialShaders(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT pSetLayoutInfos(@NativeType(value="VkIndirectExecutionSetShaderLayoutInfoEXT const *") @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer value) {
        VkIndirectExecutionSetShaderInfoEXT.npSetLayoutInfos(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT maxShaderCount(@NativeType(value="uint32_t") int value) {
        VkIndirectExecutionSetShaderInfoEXT.nmaxShaderCount(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT pPushConstantRanges(@NativeType(value="VkPushConstantRange const *") @Nullable VkPushConstantRange.Buffer value) {
        VkIndirectExecutionSetShaderInfoEXT.npPushConstantRanges(this.address(), value);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT set(int sType, long pNext, int shaderCount, LongBuffer pInitialShaders, @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer pSetLayoutInfos, int maxShaderCount, @Nullable VkPushConstantRange.Buffer pPushConstantRanges) {
        this.sType(sType);
        this.pNext(pNext);
        this.shaderCount(shaderCount);
        this.pInitialShaders(pInitialShaders);
        this.pSetLayoutInfos(pSetLayoutInfos);
        this.maxShaderCount(maxShaderCount);
        this.pPushConstantRanges(pPushConstantRanges);
        return this;
    }

    public VkIndirectExecutionSetShaderInfoEXT set(VkIndirectExecutionSetShaderInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkIndirectExecutionSetShaderInfoEXT malloc() {
        return new VkIndirectExecutionSetShaderInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkIndirectExecutionSetShaderInfoEXT calloc() {
        return new VkIndirectExecutionSetShaderInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkIndirectExecutionSetShaderInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkIndirectExecutionSetShaderInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkIndirectExecutionSetShaderInfoEXT create(long address) {
        return new VkIndirectExecutionSetShaderInfoEXT(address, null);
    }

    public static @Nullable VkIndirectExecutionSetShaderInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkIndirectExecutionSetShaderInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkIndirectExecutionSetShaderInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkIndirectExecutionSetShaderInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkIndirectExecutionSetShaderInfoEXT malloc(MemoryStack stack) {
        return new VkIndirectExecutionSetShaderInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkIndirectExecutionSetShaderInfoEXT calloc(MemoryStack stack) {
        return new VkIndirectExecutionSetShaderInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nshaderCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERCOUNT);
    }

    public static LongBuffer npInitialShaders(long struct) {
        return MemoryUtil.memLongBuffer(MemoryUtil.memGetAddress(struct + (long)PINITIALSHADERS), VkIndirectExecutionSetShaderInfoEXT.nshaderCount(struct));
    }

    public static @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer npSetLayoutInfos(long struct) {
        return VkIndirectExecutionSetShaderLayoutInfoEXT.createSafe(MemoryUtil.memGetAddress(struct + (long)PSETLAYOUTINFOS), VkIndirectExecutionSetShaderInfoEXT.nshaderCount(struct));
    }

    public static int nmaxShaderCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXSHADERCOUNT);
    }

    public static int npushConstantRangeCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PUSHCONSTANTRANGECOUNT);
    }

    public static @Nullable VkPushConstantRange.Buffer npPushConstantRanges(long struct) {
        return VkPushConstantRange.createSafe(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES), VkIndirectExecutionSetShaderInfoEXT.npushConstantRangeCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nshaderCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SHADERCOUNT, value);
    }

    public static void npInitialShaders(long struct, LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PINITIALSHADERS, MemoryUtil.memAddress(value));
    }

    public static void npSetLayoutInfos(long struct, @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSETLAYOUTINFOS, MemoryUtil.memAddressSafe(value));
    }

    public static void nmaxShaderCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAXSHADERCOUNT, value);
    }

    public static void npushConstantRangeCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PUSHCONSTANTRANGECOUNT, value);
    }

    public static void npPushConstantRanges(long struct, @Nullable VkPushConstantRange.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPUSHCONSTANTRANGES, MemoryUtil.memAddressSafe(value));
        VkIndirectExecutionSetShaderInfoEXT.npushConstantRangeCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PINITIALSHADERS));
        if (VkIndirectExecutionSetShaderInfoEXT.npushConstantRangeCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPUSHCONSTANTRANGES));
        }
    }

    static {
        Struct.Layout layout = VkIndirectExecutionSetShaderInfoEXT.__struct(VkIndirectExecutionSetShaderInfoEXT.__member(4), VkIndirectExecutionSetShaderInfoEXT.__member(POINTER_SIZE), VkIndirectExecutionSetShaderInfoEXT.__member(4), VkIndirectExecutionSetShaderInfoEXT.__member(POINTER_SIZE), VkIndirectExecutionSetShaderInfoEXT.__member(POINTER_SIZE), VkIndirectExecutionSetShaderInfoEXT.__member(4), VkIndirectExecutionSetShaderInfoEXT.__member(4), VkIndirectExecutionSetShaderInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SHADERCOUNT = layout.offsetof(2);
        PINITIALSHADERS = layout.offsetof(3);
        PSETLAYOUTINFOS = layout.offsetof(4);
        MAXSHADERCOUNT = layout.offsetof(5);
        PUSHCONSTANTRANGECOUNT = layout.offsetof(6);
        PPUSHCONSTANTRANGES = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkIndirectExecutionSetShaderInfoEXT, Buffer>
    implements NativeResource {
        private static final VkIndirectExecutionSetShaderInfoEXT ELEMENT_FACTORY = VkIndirectExecutionSetShaderInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkIndirectExecutionSetShaderInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkIndirectExecutionSetShaderInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkIndirectExecutionSetShaderInfoEXT.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int shaderCount() {
            return VkIndirectExecutionSetShaderInfoEXT.nshaderCount(this.address());
        }

        @NativeType(value="VkShaderEXT const *")
        public LongBuffer pInitialShaders() {
            return VkIndirectExecutionSetShaderInfoEXT.npInitialShaders(this.address());
        }

        @NativeType(value="VkIndirectExecutionSetShaderLayoutInfoEXT const *")
        public @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer pSetLayoutInfos() {
            return VkIndirectExecutionSetShaderInfoEXT.npSetLayoutInfos(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxShaderCount() {
            return VkIndirectExecutionSetShaderInfoEXT.nmaxShaderCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int pushConstantRangeCount() {
            return VkIndirectExecutionSetShaderInfoEXT.npushConstantRangeCount(this.address());
        }

        @NativeType(value="VkPushConstantRange const *")
        public @Nullable VkPushConstantRange.Buffer pPushConstantRanges() {
            return VkIndirectExecutionSetShaderInfoEXT.npPushConstantRanges(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkIndirectExecutionSetShaderInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000572011);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkIndirectExecutionSetShaderInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer shaderCount(@NativeType(value="uint32_t") int value) {
            VkIndirectExecutionSetShaderInfoEXT.nshaderCount(this.address(), value);
            return this;
        }

        public Buffer pInitialShaders(@NativeType(value="VkShaderEXT const *") LongBuffer value) {
            VkIndirectExecutionSetShaderInfoEXT.npInitialShaders(this.address(), value);
            return this;
        }

        public Buffer pSetLayoutInfos(@NativeType(value="VkIndirectExecutionSetShaderLayoutInfoEXT const *") @Nullable VkIndirectExecutionSetShaderLayoutInfoEXT.Buffer value) {
            VkIndirectExecutionSetShaderInfoEXT.npSetLayoutInfos(this.address(), value);
            return this;
        }

        public Buffer maxShaderCount(@NativeType(value="uint32_t") int value) {
            VkIndirectExecutionSetShaderInfoEXT.nmaxShaderCount(this.address(), value);
            return this;
        }

        public Buffer pPushConstantRanges(@NativeType(value="VkPushConstantRange const *") @Nullable VkPushConstantRange.Buffer value) {
            VkIndirectExecutionSetShaderInfoEXT.npPushConstantRanges(this.address(), value);
            return this;
        }
    }
}

