/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryBarrier2
extends Struct<VkMemoryBarrier2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SRCSTAGEMASK;
    public static final int SRCACCESSMASK;
    public static final int DSTSTAGEMASK;
    public static final int DSTACCESSMASK;

    protected VkMemoryBarrier2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryBarrier2 create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryBarrier2(address, container);
    }

    public VkMemoryBarrier2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryBarrier2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryBarrier2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryBarrier2.npNext(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long srcStageMask() {
        return VkMemoryBarrier2.nsrcStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long srcAccessMask() {
        return VkMemoryBarrier2.nsrcAccessMask(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long dstStageMask() {
        return VkMemoryBarrier2.ndstStageMask(this.address());
    }

    @NativeType(value="VkAccessFlags2")
    public long dstAccessMask() {
        return VkMemoryBarrier2.ndstAccessMask(this.address());
    }

    public VkMemoryBarrier2 sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryBarrier2.nsType(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 sType$Default() {
        return this.sType(1000314000);
    }

    public VkMemoryBarrier2 pNext(@NativeType(value="void const *") long value) {
        VkMemoryBarrier2.npNext(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2.nsrcStageMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2.nsrcAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkMemoryBarrier2.ndstStageMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
        VkMemoryBarrier2.ndstAccessMask(this.address(), value);
        return this;
    }

    public VkMemoryBarrier2 set(int sType, long pNext, long srcStageMask, long srcAccessMask, long dstStageMask, long dstAccessMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.srcStageMask(srcStageMask);
        this.srcAccessMask(srcAccessMask);
        this.dstStageMask(dstStageMask);
        this.dstAccessMask(dstAccessMask);
        return this;
    }

    public VkMemoryBarrier2 set(VkMemoryBarrier2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryBarrier2 malloc() {
        return new VkMemoryBarrier2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryBarrier2 calloc() {
        return new VkMemoryBarrier2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryBarrier2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryBarrier2(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryBarrier2 create(long address) {
        return new VkMemoryBarrier2(address, null);
    }

    public static @Nullable VkMemoryBarrier2 createSafe(long address) {
        return address == 0L ? null : new VkMemoryBarrier2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryBarrier2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryBarrier2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryBarrier2 malloc(MemoryStack stack) {
        return new VkMemoryBarrier2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryBarrier2 calloc(MemoryStack stack) {
        return new VkMemoryBarrier2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsrcStageMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCSTAGEMASK);
    }

    public static long nsrcAccessMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SRCACCESSMASK);
    }

    public static long ndstStageMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTSTAGEMASK);
    }

    public static long ndstAccessMask(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DSTACCESSMASK);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsrcStageMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCSTAGEMASK, value);
    }

    public static void nsrcAccessMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SRCACCESSMASK, value);
    }

    public static void ndstStageMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTSTAGEMASK, value);
    }

    public static void ndstAccessMask(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)DSTACCESSMASK, value);
    }

    static {
        Struct.Layout layout = VkMemoryBarrier2.__struct(VkMemoryBarrier2.__member(4), VkMemoryBarrier2.__member(POINTER_SIZE), VkMemoryBarrier2.__member(8), VkMemoryBarrier2.__member(8), VkMemoryBarrier2.__member(8), VkMemoryBarrier2.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SRCSTAGEMASK = layout.offsetof(2);
        SRCACCESSMASK = layout.offsetof(3);
        DSTSTAGEMASK = layout.offsetof(4);
        DSTACCESSMASK = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryBarrier2, Buffer>
    implements NativeResource {
        private static final VkMemoryBarrier2 ELEMENT_FACTORY = VkMemoryBarrier2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryBarrier2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryBarrier2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryBarrier2.npNext(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long srcStageMask() {
            return VkMemoryBarrier2.nsrcStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long srcAccessMask() {
            return VkMemoryBarrier2.nsrcAccessMask(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long dstStageMask() {
            return VkMemoryBarrier2.ndstStageMask(this.address());
        }

        @NativeType(value="VkAccessFlags2")
        public long dstAccessMask() {
            return VkMemoryBarrier2.ndstAccessMask(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryBarrier2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryBarrier2.npNext(this.address(), value);
            return this;
        }

        public Buffer srcStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2.nsrcStageMask(this.address(), value);
            return this;
        }

        public Buffer srcAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2.nsrcAccessMask(this.address(), value);
            return this;
        }

        public Buffer dstStageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkMemoryBarrier2.ndstStageMask(this.address(), value);
            return this;
        }

        public Buffer dstAccessMask(@NativeType(value="VkAccessFlags2") long value) {
            VkMemoryBarrier2.ndstAccessMask(this.address(), value);
            return this;
        }
    }
}

