/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryOpaqueCaptureAddressAllocateInfo
extends Struct<VkMemoryOpaqueCaptureAddressAllocateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OPAQUECAPTUREADDRESS;

    protected VkMemoryOpaqueCaptureAddressAllocateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryOpaqueCaptureAddressAllocateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(address, container);
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryOpaqueCaptureAddressAllocateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address());
    }

    @NativeType(value="uint64_t")
    public long opaqueCaptureAddress() {
        return VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address());
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo sType$Default() {
        return this.sType(1000257003);
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
        VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address(), value);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo set(int sType, long pNext, long opaqueCaptureAddress) {
        this.sType(sType);
        this.pNext(pNext);
        this.opaqueCaptureAddress(opaqueCaptureAddress);
        return this;
    }

    public VkMemoryOpaqueCaptureAddressAllocateInfo set(VkMemoryOpaqueCaptureAddressAllocateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo malloc() {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo calloc() {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo create(long address) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(address, null);
    }

    public static @Nullable VkMemoryOpaqueCaptureAddressAllocateInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryOpaqueCaptureAddressAllocateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryOpaqueCaptureAddressAllocateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryOpaqueCaptureAddressAllocateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo malloc(MemoryStack stack) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryOpaqueCaptureAddressAllocateInfo calloc(MemoryStack stack) {
        return new VkMemoryOpaqueCaptureAddressAllocateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nopaqueCaptureAddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)OPAQUECAPTUREADDRESS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nopaqueCaptureAddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)OPAQUECAPTUREADDRESS, value);
    }

    static {
        Struct.Layout layout = VkMemoryOpaqueCaptureAddressAllocateInfo.__struct(VkMemoryOpaqueCaptureAddressAllocateInfo.__member(4), VkMemoryOpaqueCaptureAddressAllocateInfo.__member(POINTER_SIZE), VkMemoryOpaqueCaptureAddressAllocateInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OPAQUECAPTUREADDRESS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryOpaqueCaptureAddressAllocateInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryOpaqueCaptureAddressAllocateInfo ELEMENT_FACTORY = VkMemoryOpaqueCaptureAddressAllocateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryOpaqueCaptureAddressAllocateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address());
        }

        @NativeType(value="uint64_t")
        public long opaqueCaptureAddress() {
            return VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000257003);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer opaqueCaptureAddress(@NativeType(value="uint64_t") long value) {
            VkMemoryOpaqueCaptureAddressAllocateInfo.nopaqueCaptureAddress(this.address(), value);
            return this;
        }
    }
}

