/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMemoryUnmapInfo
extends Struct<VkMemoryUnmapInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int MEMORY;

    protected VkMemoryUnmapInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryUnmapInfo create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryUnmapInfo(address, container);
    }

    public VkMemoryUnmapInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMemoryUnmapInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkMemoryUnmapInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkMemoryUnmapInfo.npNext(this.address());
    }

    @NativeType(value="VkMemoryUnmapFlags")
    public int flags() {
        return VkMemoryUnmapInfo.nflags(this.address());
    }

    @NativeType(value="VkDeviceMemory")
    public long memory() {
        return VkMemoryUnmapInfo.nmemory(this.address());
    }

    public VkMemoryUnmapInfo sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryUnmapInfo.nsType(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfo sType$Default() {
        return this.sType(1000271001);
    }

    public VkMemoryUnmapInfo pNext(@NativeType(value="void const *") long value) {
        VkMemoryUnmapInfo.npNext(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfo flags(@NativeType(value="VkMemoryUnmapFlags") int value) {
        VkMemoryUnmapInfo.nflags(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfo memory(@NativeType(value="VkDeviceMemory") long value) {
        VkMemoryUnmapInfo.nmemory(this.address(), value);
        return this;
    }

    public VkMemoryUnmapInfo set(int sType, long pNext, int flags, long memory) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.memory(memory);
        return this;
    }

    public VkMemoryUnmapInfo set(VkMemoryUnmapInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryUnmapInfo malloc() {
        return new VkMemoryUnmapInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryUnmapInfo calloc() {
        return new VkMemoryUnmapInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryUnmapInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryUnmapInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryUnmapInfo create(long address) {
        return new VkMemoryUnmapInfo(address, null);
    }

    public static @Nullable VkMemoryUnmapInfo createSafe(long address) {
        return address == 0L ? null : new VkMemoryUnmapInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryUnmapInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryUnmapInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMemoryUnmapInfo malloc(MemoryStack stack) {
        return new VkMemoryUnmapInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryUnmapInfo calloc(MemoryStack stack) {
        return new VkMemoryUnmapInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static long nmemory(long struct) {
        return MemoryUtil.memGetLong(struct + (long)MEMORY);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nmemory(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)MEMORY, value);
    }

    static {
        Struct.Layout layout = VkMemoryUnmapInfo.__struct(VkMemoryUnmapInfo.__member(4), VkMemoryUnmapInfo.__member(POINTER_SIZE), VkMemoryUnmapInfo.__member(4), VkMemoryUnmapInfo.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        MEMORY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkMemoryUnmapInfo, Buffer>
    implements NativeResource {
        private static final VkMemoryUnmapInfo ELEMENT_FACTORY = VkMemoryUnmapInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMemoryUnmapInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkMemoryUnmapInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkMemoryUnmapInfo.npNext(this.address());
        }

        @NativeType(value="VkMemoryUnmapFlags")
        public int flags() {
            return VkMemoryUnmapInfo.nflags(this.address());
        }

        @NativeType(value="VkDeviceMemory")
        public long memory() {
            return VkMemoryUnmapInfo.nmemory(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryUnmapInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000271001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryUnmapInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkMemoryUnmapFlags") int value) {
            VkMemoryUnmapInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer memory(@NativeType(value="VkDeviceMemory") long value) {
            VkMemoryUnmapInfo.nmemory(this.address(), value);
            return this;
        }
    }
}

