/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkMicromapUsageEXT
extends Struct<VkMicromapUsageEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COUNT;
    public static final int SUBDIVISIONLEVEL;
    public static final int FORMAT;

    protected VkMicromapUsageEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMicromapUsageEXT create(long address, @Nullable ByteBuffer container) {
        return new VkMicromapUsageEXT(address, container);
    }

    public VkMicromapUsageEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkMicromapUsageEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int count() {
        return VkMicromapUsageEXT.ncount(this.address());
    }

    @NativeType(value="uint32_t")
    public int subdivisionLevel() {
        return VkMicromapUsageEXT.nsubdivisionLevel(this.address());
    }

    @NativeType(value="uint32_t")
    public int format() {
        return VkMicromapUsageEXT.nformat(this.address());
    }

    public VkMicromapUsageEXT count(@NativeType(value="uint32_t") int value) {
        VkMicromapUsageEXT.ncount(this.address(), value);
        return this;
    }

    public VkMicromapUsageEXT subdivisionLevel(@NativeType(value="uint32_t") int value) {
        VkMicromapUsageEXT.nsubdivisionLevel(this.address(), value);
        return this;
    }

    public VkMicromapUsageEXT format(@NativeType(value="uint32_t") int value) {
        VkMicromapUsageEXT.nformat(this.address(), value);
        return this;
    }

    public VkMicromapUsageEXT set(int count, int subdivisionLevel, int format) {
        this.count(count);
        this.subdivisionLevel(subdivisionLevel);
        this.format(format);
        return this;
    }

    public VkMicromapUsageEXT set(VkMicromapUsageEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMicromapUsageEXT malloc() {
        return new VkMicromapUsageEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMicromapUsageEXT calloc() {
        return new VkMicromapUsageEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMicromapUsageEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMicromapUsageEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkMicromapUsageEXT create(long address) {
        return new VkMicromapUsageEXT(address, null);
    }

    public static @Nullable VkMicromapUsageEXT createSafe(long address) {
        return address == 0L ? null : new VkMicromapUsageEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMicromapUsageEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMicromapUsageEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkMicromapUsageEXT malloc(MemoryStack stack) {
        return new VkMicromapUsageEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMicromapUsageEXT calloc(MemoryStack stack) {
        return new VkMicromapUsageEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COUNT);
    }

    public static int nsubdivisionLevel(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBDIVISIONLEVEL);
    }

    public static int nformat(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FORMAT);
    }

    public static void ncount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COUNT, value);
    }

    public static void nsubdivisionLevel(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBDIVISIONLEVEL, value);
    }

    public static void nformat(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FORMAT, value);
    }

    static {
        Struct.Layout layout = VkMicromapUsageEXT.__struct(VkMicromapUsageEXT.__member(4), VkMicromapUsageEXT.__member(4), VkMicromapUsageEXT.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COUNT = layout.offsetof(0);
        SUBDIVISIONLEVEL = layout.offsetof(1);
        FORMAT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkMicromapUsageEXT, Buffer>
    implements NativeResource {
        private static final VkMicromapUsageEXT ELEMENT_FACTORY = VkMicromapUsageEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkMicromapUsageEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int count() {
            return VkMicromapUsageEXT.ncount(this.address());
        }

        @NativeType(value="uint32_t")
        public int subdivisionLevel() {
            return VkMicromapUsageEXT.nsubdivisionLevel(this.address());
        }

        @NativeType(value="uint32_t")
        public int format() {
            return VkMicromapUsageEXT.nformat(this.address());
        }

        public Buffer count(@NativeType(value="uint32_t") int value) {
            VkMicromapUsageEXT.ncount(this.address(), value);
            return this;
        }

        public Buffer subdivisionLevel(@NativeType(value="uint32_t") int value) {
            VkMicromapUsageEXT.nsubdivisionLevel(this.address(), value);
            return this;
        }

        public Buffer format(@NativeType(value="uint32_t") int value) {
            VkMicromapUsageEXT.nformat(this.address(), value);
            return this;
        }
    }
}

