/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkOffset3D
extends Struct<VkOffset3D>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int Z;

    protected VkOffset3D(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkOffset3D create(long address, @Nullable ByteBuffer container) {
        return new VkOffset3D(address, container);
    }

    public VkOffset3D(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkOffset3D.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int x() {
        return VkOffset3D.nx(this.address());
    }

    @NativeType(value="int32_t")
    public int y() {
        return VkOffset3D.ny(this.address());
    }

    @NativeType(value="int32_t")
    public int z() {
        return VkOffset3D.nz(this.address());
    }

    public VkOffset3D x(@NativeType(value="int32_t") int value) {
        VkOffset3D.nx(this.address(), value);
        return this;
    }

    public VkOffset3D y(@NativeType(value="int32_t") int value) {
        VkOffset3D.ny(this.address(), value);
        return this;
    }

    public VkOffset3D z(@NativeType(value="int32_t") int value) {
        VkOffset3D.nz(this.address(), value);
        return this;
    }

    public VkOffset3D set(int x, int y, int z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public VkOffset3D set(VkOffset3D src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkOffset3D malloc() {
        return new VkOffset3D(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkOffset3D calloc() {
        return new VkOffset3D(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkOffset3D create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkOffset3D(MemoryUtil.memAddress(container), container);
    }

    public static VkOffset3D create(long address) {
        return new VkOffset3D(address, null);
    }

    public static @Nullable VkOffset3D createSafe(long address) {
        return address == 0L ? null : new VkOffset3D(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkOffset3D.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkOffset3D.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkOffset3D mallocStack() {
        return VkOffset3D.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset3D callocStack() {
        return VkOffset3D.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkOffset3D mallocStack(MemoryStack stack) {
        return VkOffset3D.malloc(stack);
    }

    @Deprecated
    public static VkOffset3D callocStack(MemoryStack stack) {
        return VkOffset3D.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkOffset3D.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkOffset3D.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkOffset3D.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkOffset3D.calloc(capacity, stack);
    }

    public static VkOffset3D malloc(MemoryStack stack) {
        return new VkOffset3D(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkOffset3D calloc(MemoryStack stack) {
        return new VkOffset3D(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return MemoryUtil.memGetInt(struct + (long)X);
    }

    public static int ny(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Y);
    }

    public static int nz(long struct) {
        return MemoryUtil.memGetInt(struct + (long)Z);
    }

    public static void nx(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Y, value);
    }

    public static void nz(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = VkOffset3D.__struct(VkOffset3D.__member(4), VkOffset3D.__member(4), VkOffset3D.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkOffset3D, Buffer>
    implements NativeResource {
        private static final VkOffset3D ELEMENT_FACTORY = VkOffset3D.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkOffset3D getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int x() {
            return VkOffset3D.nx(this.address());
        }

        @NativeType(value="int32_t")
        public int y() {
            return VkOffset3D.ny(this.address());
        }

        @NativeType(value="int32_t")
        public int z() {
            return VkOffset3D.nz(this.address());
        }

        public Buffer x(@NativeType(value="int32_t") int value) {
            VkOffset3D.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="int32_t") int value) {
            VkOffset3D.ny(this.address(), value);
            return this;
        }

        public Buffer z(@NativeType(value="int32_t") int value) {
            VkOffset3D.nz(this.address(), value);
            return this;
        }
    }
}

