/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceGroupProperties
extends Struct<VkPhysicalDeviceGroupProperties>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PHYSICALDEVICECOUNT;
    public static final int PHYSICALDEVICES;
    public static final int SUBSETALLOCATION;

    protected VkPhysicalDeviceGroupProperties(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceGroupProperties create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceGroupProperties(address, container);
    }

    public VkPhysicalDeviceGroupProperties(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceGroupProperties.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceGroupProperties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceGroupProperties.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int physicalDeviceCount() {
        return VkPhysicalDeviceGroupProperties.nphysicalDeviceCount(this.address());
    }

    @NativeType(value="VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]")
    public PointerBuffer physicalDevices() {
        return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address());
    }

    @NativeType(value="VkPhysicalDevice")
    public long physicalDevices(int index) {
        return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address(), index);
    }

    @NativeType(value="VkBool32")
    public boolean subsetAllocation() {
        return VkPhysicalDeviceGroupProperties.nsubsetAllocation(this.address()) != 0;
    }

    public VkPhysicalDeviceGroupProperties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceGroupProperties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceGroupProperties sType$Default() {
        return this.sType(1000070000);
    }

    public VkPhysicalDeviceGroupProperties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceGroupProperties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceGroupProperties set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceGroupProperties set(VkPhysicalDeviceGroupProperties src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceGroupProperties malloc() {
        return new VkPhysicalDeviceGroupProperties(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceGroupProperties calloc() {
        return new VkPhysicalDeviceGroupProperties(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceGroupProperties create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceGroupProperties(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceGroupProperties create(long address) {
        return new VkPhysicalDeviceGroupProperties(address, null);
    }

    public static @Nullable VkPhysicalDeviceGroupProperties createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceGroupProperties(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceGroupProperties.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceGroupProperties.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceGroupProperties mallocStack() {
        return VkPhysicalDeviceGroupProperties.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceGroupProperties callocStack() {
        return VkPhysicalDeviceGroupProperties.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceGroupProperties mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceGroupProperties callocStack(MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceGroupProperties.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceGroupProperties.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceGroupProperties.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceGroupProperties malloc(MemoryStack stack) {
        return new VkPhysicalDeviceGroupProperties(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceGroupProperties calloc(MemoryStack stack) {
        return new VkPhysicalDeviceGroupProperties(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nphysicalDeviceCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PHYSICALDEVICECOUNT);
    }

    public static PointerBuffer nphysicalDevices(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PHYSICALDEVICES, VkPhysicalDeviceGroupProperties.nphysicalDeviceCount(struct));
    }

    public static long nphysicalDevices(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PHYSICALDEVICES + Checks.check(index, 32) * (long)POINTER_SIZE);
    }

    public static int nsubsetAllocation(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBSETALLOCATION);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceGroupProperties.__struct(VkPhysicalDeviceGroupProperties.__member(4), VkPhysicalDeviceGroupProperties.__member(POINTER_SIZE), VkPhysicalDeviceGroupProperties.__member(4), VkPhysicalDeviceGroupProperties.__array(POINTER_SIZE, 32), VkPhysicalDeviceGroupProperties.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PHYSICALDEVICECOUNT = layout.offsetof(2);
        PHYSICALDEVICES = layout.offsetof(3);
        SUBSETALLOCATION = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceGroupProperties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceGroupProperties ELEMENT_FACTORY = VkPhysicalDeviceGroupProperties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDeviceGroupProperties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceGroupProperties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceGroupProperties.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int physicalDeviceCount() {
            return VkPhysicalDeviceGroupProperties.nphysicalDeviceCount(this.address());
        }

        @NativeType(value="VkPhysicalDevice[VK_MAX_DEVICE_GROUP_SIZE]")
        public PointerBuffer physicalDevices() {
            return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address());
        }

        @NativeType(value="VkPhysicalDevice")
        public long physicalDevices(int index) {
            return VkPhysicalDeviceGroupProperties.nphysicalDevices(this.address(), index);
        }

        @NativeType(value="VkBool32")
        public boolean subsetAllocation() {
            return VkPhysicalDeviceGroupProperties.nsubsetAllocation(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceGroupProperties.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000070000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceGroupProperties.npNext(this.address(), value);
            return this;
        }
    }
}

