/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPhysicalDeviceLayeredApiVulkanPropertiesKHR;

public class VkPhysicalDeviceLayeredApiPropertiesKHR
extends Struct<VkPhysicalDeviceLayeredApiPropertiesKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int LAYEREDAPI;
    public static final int DEVICENAME;

    protected VkPhysicalDeviceLayeredApiPropertiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceLayeredApiPropertiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(address, container);
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceLayeredApiPropertiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int vendorID() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.nvendorID(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceID() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceID(this.address());
    }

    @NativeType(value="VkPhysicalDeviceLayeredApiKHR")
    public int layeredAPI() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.nlayeredAPI(this.address());
    }

    @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
    public ByteBuffer deviceName() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceName(this.address());
    }

    @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
    public String deviceNameString() {
        return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceNameString(this.address());
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceLayeredApiPropertiesKHR.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR sType$Default() {
        return this.sType(1000562003);
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceLayeredApiPropertiesKHR.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR pNext(VkPhysicalDeviceLayeredApiVulkanPropertiesKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPhysicalDeviceLayeredApiPropertiesKHR set(VkPhysicalDeviceLayeredApiPropertiesKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR malloc() {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR calloc() {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR create(long address) {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(address, null);
    }

    public static @Nullable VkPhysicalDeviceLayeredApiPropertiesKHR createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceLayeredApiPropertiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceLayeredApiPropertiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceLayeredApiPropertiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR malloc(MemoryStack stack) {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceLayeredApiPropertiesKHR calloc(MemoryStack stack) {
        return new VkPhysicalDeviceLayeredApiPropertiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nvendorID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VENDORID);
    }

    public static int ndeviceID(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEVICEID);
    }

    public static int nlayeredAPI(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYEREDAPI);
    }

    public static ByteBuffer ndeviceName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)DEVICENAME, 256);
    }

    public static String ndeviceNameString(long struct) {
        return MemoryUtil.memUTF8(struct + (long)DEVICENAME);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceLayeredApiPropertiesKHR.__struct(VkPhysicalDeviceLayeredApiPropertiesKHR.__member(4), VkPhysicalDeviceLayeredApiPropertiesKHR.__member(POINTER_SIZE), VkPhysicalDeviceLayeredApiPropertiesKHR.__member(4), VkPhysicalDeviceLayeredApiPropertiesKHR.__member(4), VkPhysicalDeviceLayeredApiPropertiesKHR.__member(4), VkPhysicalDeviceLayeredApiPropertiesKHR.__array(1, 256));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        LAYEREDAPI = layout.offsetof(4);
        DEVICENAME = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceLayeredApiPropertiesKHR, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceLayeredApiPropertiesKHR ELEMENT_FACTORY = VkPhysicalDeviceLayeredApiPropertiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDeviceLayeredApiPropertiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int vendorID() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.nvendorID(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceID() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceID(this.address());
        }

        @NativeType(value="VkPhysicalDeviceLayeredApiKHR")
        public int layeredAPI() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.nlayeredAPI(this.address());
        }

        @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
        public ByteBuffer deviceName() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceName(this.address());
        }

        @NativeType(value="char[VK_MAX_PHYSICAL_DEVICE_NAME_SIZE]")
        public String deviceNameString() {
            return VkPhysicalDeviceLayeredApiPropertiesKHR.ndeviceNameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceLayeredApiPropertiesKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000562003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceLayeredApiPropertiesKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPhysicalDeviceLayeredApiVulkanPropertiesKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }
    }
}

