/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPhysicalDeviceProtectedMemoryFeatures
extends Struct<VkPhysicalDeviceProtectedMemoryFeatures>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PROTECTEDMEMORY;

    protected VkPhysicalDeviceProtectedMemoryFeatures(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPhysicalDeviceProtectedMemoryFeatures create(long address, @Nullable ByteBuffer container) {
        return new VkPhysicalDeviceProtectedMemoryFeatures(address, container);
    }

    public VkPhysicalDeviceProtectedMemoryFeatures(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPhysicalDeviceProtectedMemoryFeatures.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean protectedMemory() {
        return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures sType$Default() {
        return this.sType(1000145001);
    }

    public VkPhysicalDeviceProtectedMemoryFeatures pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures protectedMemory(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(int sType, long pNext, boolean protectedMemory) {
        this.sType(sType);
        this.pNext(pNext);
        this.protectedMemory(protectedMemory);
        return this;
    }

    public VkPhysicalDeviceProtectedMemoryFeatures set(VkPhysicalDeviceProtectedMemoryFeatures src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures malloc() {
        return new VkPhysicalDeviceProtectedMemoryFeatures(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures calloc() {
        return new VkPhysicalDeviceProtectedMemoryFeatures(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPhysicalDeviceProtectedMemoryFeatures(MemoryUtil.memAddress(container), container);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures create(long address) {
        return new VkPhysicalDeviceProtectedMemoryFeatures(address, null);
    }

    public static @Nullable VkPhysicalDeviceProtectedMemoryFeatures createSafe(long address) {
        return address == 0L ? null : new VkPhysicalDeviceProtectedMemoryFeatures(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPhysicalDeviceProtectedMemoryFeatures.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceProtectedMemoryFeatures.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack() {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures mallocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(stack);
    }

    @Deprecated
    public static VkPhysicalDeviceProtectedMemoryFeatures callocStack(MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPhysicalDeviceProtectedMemoryFeatures.calloc(capacity, stack);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures malloc(MemoryStack stack) {
        return new VkPhysicalDeviceProtectedMemoryFeatures(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPhysicalDeviceProtectedMemoryFeatures calloc(MemoryStack stack) {
        return new VkPhysicalDeviceProtectedMemoryFeatures(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nprotectedMemory(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PROTECTEDMEMORY);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nprotectedMemory(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PROTECTEDMEMORY, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceProtectedMemoryFeatures.__struct(VkPhysicalDeviceProtectedMemoryFeatures.__member(4), VkPhysicalDeviceProtectedMemoryFeatures.__member(POINTER_SIZE), VkPhysicalDeviceProtectedMemoryFeatures.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PROTECTEDMEMORY = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceProtectedMemoryFeatures, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceProtectedMemoryFeatures ELEMENT_FACTORY = VkPhysicalDeviceProtectedMemoryFeatures.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPhysicalDeviceProtectedMemoryFeatures getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean protectedMemory() {
            return VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address()) != 0;
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000145001);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceProtectedMemoryFeatures.npNext(this.address(), value);
            return this;
        }

        public Buffer protectedMemory(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceProtectedMemoryFeatures.nprotectedMemory(this.address(), value ? 1 : 0);
            return this;
        }
    }
}

