/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineBinaryHandlesInfoKHR
extends Struct<VkPipelineBinaryHandlesInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINEBINARYCOUNT;
    public static final int PPIPELINEBINARIES;

    protected VkPipelineBinaryHandlesInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineBinaryHandlesInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineBinaryHandlesInfoKHR(address, container);
    }

    public VkPipelineBinaryHandlesInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineBinaryHandlesInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineBinaryHandlesInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineBinaryHandlesInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int pipelineBinaryCount() {
        return VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(this.address());
    }

    @NativeType(value="VkPipelineBinaryKHR *")
    public @Nullable LongBuffer pPipelineBinaries() {
        return VkPipelineBinaryHandlesInfoKHR.npPipelineBinaries(this.address());
    }

    public VkPipelineBinaryHandlesInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineBinaryHandlesInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineBinaryHandlesInfoKHR sType$Default() {
        return this.sType(1000483009);
    }

    public VkPipelineBinaryHandlesInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineBinaryHandlesInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineBinaryHandlesInfoKHR pipelineBinaryCount(@NativeType(value="uint32_t") int value) {
        VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(this.address(), value);
        return this;
    }

    public VkPipelineBinaryHandlesInfoKHR pPipelineBinaries(@NativeType(value="VkPipelineBinaryKHR *") @Nullable LongBuffer value) {
        VkPipelineBinaryHandlesInfoKHR.npPipelineBinaries(this.address(), value);
        return this;
    }

    public VkPipelineBinaryHandlesInfoKHR set(int sType, long pNext, int pipelineBinaryCount, @Nullable LongBuffer pPipelineBinaries) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipelineBinaryCount(pipelineBinaryCount);
        this.pPipelineBinaries(pPipelineBinaries);
        return this;
    }

    public VkPipelineBinaryHandlesInfoKHR set(VkPipelineBinaryHandlesInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineBinaryHandlesInfoKHR malloc() {
        return new VkPipelineBinaryHandlesInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineBinaryHandlesInfoKHR calloc() {
        return new VkPipelineBinaryHandlesInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineBinaryHandlesInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineBinaryHandlesInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineBinaryHandlesInfoKHR create(long address) {
        return new VkPipelineBinaryHandlesInfoKHR(address, null);
    }

    public static @Nullable VkPipelineBinaryHandlesInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineBinaryHandlesInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineBinaryHandlesInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineBinaryHandlesInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineBinaryHandlesInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineBinaryHandlesInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineBinaryHandlesInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineBinaryHandlesInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int npipelineBinaryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIPELINEBINARYCOUNT);
    }

    public static @Nullable LongBuffer npPipelineBinaries(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARIES), VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npipelineBinaryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIPELINEBINARYCOUNT, value);
    }

    public static void npPipelineBinaries(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINEBINARIES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPipelineBinaryHandlesInfoKHR.__struct(VkPipelineBinaryHandlesInfoKHR.__member(4), VkPipelineBinaryHandlesInfoKHR.__member(POINTER_SIZE), VkPipelineBinaryHandlesInfoKHR.__member(4), VkPipelineBinaryHandlesInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINEBINARYCOUNT = layout.offsetof(2);
        PPIPELINEBINARIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineBinaryHandlesInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineBinaryHandlesInfoKHR ELEMENT_FACTORY = VkPipelineBinaryHandlesInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineBinaryHandlesInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineBinaryHandlesInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineBinaryHandlesInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int pipelineBinaryCount() {
            return VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(this.address());
        }

        @NativeType(value="VkPipelineBinaryKHR *")
        public @Nullable LongBuffer pPipelineBinaries() {
            return VkPipelineBinaryHandlesInfoKHR.npPipelineBinaries(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineBinaryHandlesInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000483009);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineBinaryHandlesInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pipelineBinaryCount(@NativeType(value="uint32_t") int value) {
            VkPipelineBinaryHandlesInfoKHR.npipelineBinaryCount(this.address(), value);
            return this;
        }

        public Buffer pPipelineBinaries(@NativeType(value="VkPipelineBinaryKHR *") @Nullable LongBuffer value) {
            VkPipelineBinaryHandlesInfoKHR.npPipelineBinaries(this.address(), value);
            return this;
        }
    }
}

