/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineBinaryInfoKHR
extends Struct<VkPipelineBinaryInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BINARYCOUNT;
    public static final int PPIPELINEBINARIES;

    protected VkPipelineBinaryInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineBinaryInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineBinaryInfoKHR(address, container);
    }

    public VkPipelineBinaryInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineBinaryInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineBinaryInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineBinaryInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int binaryCount() {
        return VkPipelineBinaryInfoKHR.nbinaryCount(this.address());
    }

    @NativeType(value="VkPipelineBinaryKHR const *")
    public @Nullable LongBuffer pPipelineBinaries() {
        return VkPipelineBinaryInfoKHR.npPipelineBinaries(this.address());
    }

    public VkPipelineBinaryInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineBinaryInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineBinaryInfoKHR sType$Default() {
        return this.sType(1000483002);
    }

    public VkPipelineBinaryInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineBinaryInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineBinaryInfoKHR pPipelineBinaries(@NativeType(value="VkPipelineBinaryKHR const *") @Nullable LongBuffer value) {
        VkPipelineBinaryInfoKHR.npPipelineBinaries(this.address(), value);
        return this;
    }

    public VkPipelineBinaryInfoKHR set(int sType, long pNext, @Nullable LongBuffer pPipelineBinaries) {
        this.sType(sType);
        this.pNext(pNext);
        this.pPipelineBinaries(pPipelineBinaries);
        return this;
    }

    public VkPipelineBinaryInfoKHR set(VkPipelineBinaryInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineBinaryInfoKHR malloc() {
        return new VkPipelineBinaryInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineBinaryInfoKHR calloc() {
        return new VkPipelineBinaryInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineBinaryInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineBinaryInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineBinaryInfoKHR create(long address) {
        return new VkPipelineBinaryInfoKHR(address, null);
    }

    public static @Nullable VkPipelineBinaryInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineBinaryInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineBinaryInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineBinaryInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineBinaryInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineBinaryInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineBinaryInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineBinaryInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nbinaryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BINARYCOUNT);
    }

    public static @Nullable LongBuffer npPipelineBinaries(long struct) {
        return MemoryUtil.memLongBufferSafe(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARIES), VkPipelineBinaryInfoKHR.nbinaryCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbinaryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BINARYCOUNT, value);
    }

    public static void npPipelineBinaries(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PPIPELINEBINARIES, MemoryUtil.memAddressSafe(value));
        VkPipelineBinaryInfoKHR.nbinaryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineBinaryInfoKHR.nbinaryCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PPIPELINEBINARIES));
        }
    }

    static {
        Struct.Layout layout = VkPipelineBinaryInfoKHR.__struct(VkPipelineBinaryInfoKHR.__member(4), VkPipelineBinaryInfoKHR.__member(POINTER_SIZE), VkPipelineBinaryInfoKHR.__member(4), VkPipelineBinaryInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BINARYCOUNT = layout.offsetof(2);
        PPIPELINEBINARIES = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineBinaryInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineBinaryInfoKHR ELEMENT_FACTORY = VkPipelineBinaryInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineBinaryInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineBinaryInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineBinaryInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int binaryCount() {
            return VkPipelineBinaryInfoKHR.nbinaryCount(this.address());
        }

        @NativeType(value="VkPipelineBinaryKHR const *")
        public @Nullable LongBuffer pPipelineBinaries() {
            return VkPipelineBinaryInfoKHR.npPipelineBinaries(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineBinaryInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000483002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineBinaryInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pPipelineBinaries(@NativeType(value="VkPipelineBinaryKHR const *") @Nullable LongBuffer value) {
            VkPipelineBinaryInfoKHR.npPipelineBinaries(this.address(), value);
            return this;
        }
    }
}

