/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineBinaryKeyKHR
extends Struct<VkPipelineBinaryKeyKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int KEYSIZE;
    public static final int KEY;

    protected VkPipelineBinaryKeyKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineBinaryKeyKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineBinaryKeyKHR(address, container);
    }

    public VkPipelineBinaryKeyKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineBinaryKeyKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineBinaryKeyKHR.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPipelineBinaryKeyKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int keySize() {
        return VkPipelineBinaryKeyKHR.nkeySize(this.address());
    }

    @NativeType(value="uint8_t[VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR]")
    public ByteBuffer key() {
        return VkPipelineBinaryKeyKHR.nkey(this.address());
    }

    @NativeType(value="uint8_t")
    public byte key(int index) {
        return VkPipelineBinaryKeyKHR.nkey(this.address(), index);
    }

    public VkPipelineBinaryKeyKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineBinaryKeyKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeyKHR sType$Default() {
        return this.sType(1000483003);
    }

    public VkPipelineBinaryKeyKHR pNext(@NativeType(value="void *") long value) {
        VkPipelineBinaryKeyKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeyKHR keySize(@NativeType(value="uint32_t") int value) {
        VkPipelineBinaryKeyKHR.nkeySize(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeyKHR key(@NativeType(value="uint8_t[VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR]") ByteBuffer value) {
        VkPipelineBinaryKeyKHR.nkey(this.address(), value);
        return this;
    }

    public VkPipelineBinaryKeyKHR key(int index, @NativeType(value="uint8_t") byte value) {
        VkPipelineBinaryKeyKHR.nkey(this.address(), index, value);
        return this;
    }

    public VkPipelineBinaryKeyKHR set(int sType, long pNext, int keySize, ByteBuffer key) {
        this.sType(sType);
        this.pNext(pNext);
        this.keySize(keySize);
        this.key(key);
        return this;
    }

    public VkPipelineBinaryKeyKHR set(VkPipelineBinaryKeyKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineBinaryKeyKHR malloc() {
        return new VkPipelineBinaryKeyKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineBinaryKeyKHR calloc() {
        return new VkPipelineBinaryKeyKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineBinaryKeyKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineBinaryKeyKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineBinaryKeyKHR create(long address) {
        return new VkPipelineBinaryKeyKHR(address, null);
    }

    public static @Nullable VkPipelineBinaryKeyKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineBinaryKeyKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineBinaryKeyKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineBinaryKeyKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelineBinaryKeyKHR malloc(MemoryStack stack) {
        return new VkPipelineBinaryKeyKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineBinaryKeyKHR calloc(MemoryStack stack) {
        return new VkPipelineBinaryKeyKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nkeySize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)KEYSIZE);
    }

    public static ByteBuffer nkey(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)KEY, 32);
    }

    public static byte nkey(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)KEY + Checks.check(index, 32) * 1L);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nkeySize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)KEYSIZE, value);
    }

    public static void nkey(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 32);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)KEY, value.remaining() * 1);
    }

    public static void nkey(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)KEY + Checks.check(index, 32) * 1L, value);
    }

    static {
        Struct.Layout layout = VkPipelineBinaryKeyKHR.__struct(VkPipelineBinaryKeyKHR.__member(4), VkPipelineBinaryKeyKHR.__member(POINTER_SIZE), VkPipelineBinaryKeyKHR.__member(4), VkPipelineBinaryKeyKHR.__array(1, 32));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        KEYSIZE = layout.offsetof(2);
        KEY = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineBinaryKeyKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineBinaryKeyKHR ELEMENT_FACTORY = VkPipelineBinaryKeyKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineBinaryKeyKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineBinaryKeyKHR.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPipelineBinaryKeyKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int keySize() {
            return VkPipelineBinaryKeyKHR.nkeySize(this.address());
        }

        @NativeType(value="uint8_t[VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR]")
        public ByteBuffer key() {
            return VkPipelineBinaryKeyKHR.nkey(this.address());
        }

        @NativeType(value="uint8_t")
        public byte key(int index) {
            return VkPipelineBinaryKeyKHR.nkey(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineBinaryKeyKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000483003);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPipelineBinaryKeyKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer keySize(@NativeType(value="uint32_t") int value) {
            VkPipelineBinaryKeyKHR.nkeySize(this.address(), value);
            return this;
        }

        public Buffer key(@NativeType(value="uint8_t[VK_MAX_PIPELINE_BINARY_KEY_SIZE_KHR]") ByteBuffer value) {
            VkPipelineBinaryKeyKHR.nkey(this.address(), value);
            return this;
        }

        public Buffer key(int index, @NativeType(value="uint8_t") byte value) {
            VkPipelineBinaryKeyKHR.nkey(this.address(), index, value);
            return this;
        }
    }
}

