/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineInfoKHR
extends Struct<VkPipelineInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINE;

    protected VkPipelineInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineInfoKHR(address, container);
    }

    public VkPipelineInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkPipeline")
    public long pipeline() {
        return VkPipelineInfoKHR.npipeline(this.address());
    }

    public VkPipelineInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR sType$Default() {
        return this.sType(1000269001);
    }

    public VkPipelineInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPipelineInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR pipeline(@NativeType(value="VkPipeline") long value) {
        VkPipelineInfoKHR.npipeline(this.address(), value);
        return this;
    }

    public VkPipelineInfoKHR set(int sType, long pNext, long pipeline) {
        this.sType(sType);
        this.pNext(pNext);
        this.pipeline(pipeline);
        return this;
    }

    public VkPipelineInfoKHR set(VkPipelineInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineInfoKHR malloc() {
        return new VkPipelineInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineInfoKHR calloc() {
        return new VkPipelineInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineInfoKHR create(long address) {
        return new VkPipelineInfoKHR(address, null);
    }

    public static @Nullable VkPipelineInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPipelineInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineInfoKHR mallocStack() {
        return VkPipelineInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineInfoKHR callocStack() {
        return VkPipelineInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineInfoKHR mallocStack(MemoryStack stack) {
        return VkPipelineInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkPipelineInfoKHR callocStack(MemoryStack stack) {
        return VkPipelineInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineInfoKHR.calloc(capacity, stack);
    }

    public static VkPipelineInfoKHR malloc(MemoryStack stack) {
        return new VkPipelineInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineInfoKHR calloc(MemoryStack stack) {
        return new VkPipelineInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long npipeline(long struct) {
        return MemoryUtil.memGetLong(struct + (long)PIPELINE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npipeline(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)PIPELINE, value);
    }

    static {
        Struct.Layout layout = VkPipelineInfoKHR.__struct(VkPipelineInfoKHR.__member(4), VkPipelineInfoKHR.__member(POINTER_SIZE), VkPipelineInfoKHR.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPipelineInfoKHR ELEMENT_FACTORY = VkPipelineInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkPipelineInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkPipeline")
        public long pipeline() {
            return VkPipelineInfoKHR.npipeline(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000269001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pipeline(@NativeType(value="VkPipeline") long value) {
            VkPipelineInfoKHR.npipeline(this.address(), value);
            return this;
        }
    }
}

