/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkOffset2D;

public class VkRectLayerKHR
extends Struct<VkRectLayerKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int OFFSET;
    public static final int EXTENT;
    public static final int LAYER;

    protected VkRectLayerKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRectLayerKHR create(long address, @Nullable ByteBuffer container) {
        return new VkRectLayerKHR(address, container);
    }

    public VkRectLayerKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRectLayerKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public VkOffset2D offset() {
        return VkRectLayerKHR.noffset(this.address());
    }

    public VkExtent2D extent() {
        return VkRectLayerKHR.nextent(this.address());
    }

    @NativeType(value="uint32_t")
    public int layer() {
        return VkRectLayerKHR.nlayer(this.address());
    }

    public VkRectLayerKHR offset(VkOffset2D value) {
        VkRectLayerKHR.noffset(this.address(), value);
        return this;
    }

    public VkRectLayerKHR offset(Consumer<VkOffset2D> consumer) {
        consumer.accept(this.offset());
        return this;
    }

    public VkRectLayerKHR extent(VkExtent2D value) {
        VkRectLayerKHR.nextent(this.address(), value);
        return this;
    }

    public VkRectLayerKHR extent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.extent());
        return this;
    }

    public VkRectLayerKHR layer(@NativeType(value="uint32_t") int value) {
        VkRectLayerKHR.nlayer(this.address(), value);
        return this;
    }

    public VkRectLayerKHR set(VkOffset2D offset, VkExtent2D extent, int layer) {
        this.offset(offset);
        this.extent(extent);
        this.layer(layer);
        return this;
    }

    public VkRectLayerKHR set(VkRectLayerKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRectLayerKHR malloc() {
        return new VkRectLayerKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRectLayerKHR calloc() {
        return new VkRectLayerKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRectLayerKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRectLayerKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkRectLayerKHR create(long address) {
        return new VkRectLayerKHR(address, null);
    }

    public static @Nullable VkRectLayerKHR createSafe(long address) {
        return address == 0L ? null : new VkRectLayerKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRectLayerKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRectLayerKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkRectLayerKHR mallocStack() {
        return VkRectLayerKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRectLayerKHR callocStack() {
        return VkRectLayerKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkRectLayerKHR mallocStack(MemoryStack stack) {
        return VkRectLayerKHR.malloc(stack);
    }

    @Deprecated
    public static VkRectLayerKHR callocStack(MemoryStack stack) {
        return VkRectLayerKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkRectLayerKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkRectLayerKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRectLayerKHR.calloc(capacity, stack);
    }

    public static VkRectLayerKHR malloc(MemoryStack stack) {
        return new VkRectLayerKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRectLayerKHR calloc(MemoryStack stack) {
        return new VkRectLayerKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static VkOffset2D noffset(long struct) {
        return VkOffset2D.create(struct + (long)OFFSET);
    }

    public static VkExtent2D nextent(long struct) {
        return VkExtent2D.create(struct + (long)EXTENT);
    }

    public static int nlayer(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYER);
    }

    public static void noffset(long struct, VkOffset2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)OFFSET, VkOffset2D.SIZEOF);
    }

    public static void nextent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EXTENT, VkExtent2D.SIZEOF);
    }

    public static void nlayer(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYER, value);
    }

    static {
        Struct.Layout layout = VkRectLayerKHR.__struct(VkRectLayerKHR.__member(VkOffset2D.SIZEOF, VkOffset2D.ALIGNOF), VkRectLayerKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkRectLayerKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        OFFSET = layout.offsetof(0);
        EXTENT = layout.offsetof(1);
        LAYER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkRectLayerKHR, Buffer>
    implements NativeResource {
        private static final VkRectLayerKHR ELEMENT_FACTORY = VkRectLayerKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkRectLayerKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public VkOffset2D offset() {
            return VkRectLayerKHR.noffset(this.address());
        }

        public VkExtent2D extent() {
            return VkRectLayerKHR.nextent(this.address());
        }

        @NativeType(value="uint32_t")
        public int layer() {
            return VkRectLayerKHR.nlayer(this.address());
        }

        public Buffer offset(VkOffset2D value) {
            VkRectLayerKHR.noffset(this.address(), value);
            return this;
        }

        public Buffer offset(Consumer<VkOffset2D> consumer) {
            consumer.accept(this.offset());
            return this;
        }

        public Buffer extent(VkExtent2D value) {
            VkRectLayerKHR.nextent(this.address(), value);
            return this;
        }

        public Buffer extent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.extent());
            return this;
        }

        public Buffer layer(@NativeType(value="uint32_t") int value) {
            VkRectLayerKHR.nlayer(this.address(), value);
            return this;
        }
    }
}

