/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkRenderingInputAttachmentIndexInfo
extends Struct<VkRenderingInputAttachmentIndexInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTINPUTINDICES;
    public static final int PDEPTHINPUTATTACHMENTINDEX;
    public static final int PSTENCILINPUTATTACHMENTINDEX;

    protected VkRenderingInputAttachmentIndexInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderingInputAttachmentIndexInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingInputAttachmentIndexInfo(address, container);
    }

    public VkRenderingInputAttachmentIndexInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderingInputAttachmentIndexInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderingInputAttachmentIndexInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderingInputAttachmentIndexInfo.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pColorAttachmentInputIndices() {
        return VkRenderingInputAttachmentIndexInfo.npColorAttachmentInputIndices(this.address());
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pDepthInputAttachmentIndex(int capacity) {
        return VkRenderingInputAttachmentIndexInfo.npDepthInputAttachmentIndex(this.address(), capacity);
    }

    @NativeType(value="uint32_t const *")
    public @Nullable IntBuffer pStencilInputAttachmentIndex(int capacity) {
        return VkRenderingInputAttachmentIndexInfo.npStencilInputAttachmentIndex(this.address(), capacity);
    }

    public VkRenderingInputAttachmentIndexInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingInputAttachmentIndexInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo sType$Default() {
        return this.sType(1000232002);
    }

    public VkRenderingInputAttachmentIndexInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderingInputAttachmentIndexInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo colorAttachmentCount(@NativeType(value="uint32_t") int value) {
        VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo pColorAttachmentInputIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderingInputAttachmentIndexInfo.npColorAttachmentInputIndices(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo pDepthInputAttachmentIndex(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderingInputAttachmentIndexInfo.npDepthInputAttachmentIndex(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo pStencilInputAttachmentIndex(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
        VkRenderingInputAttachmentIndexInfo.npStencilInputAttachmentIndex(this.address(), value);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo set(int sType, long pNext, int colorAttachmentCount, @Nullable IntBuffer pColorAttachmentInputIndices, @Nullable IntBuffer pDepthInputAttachmentIndex, @Nullable IntBuffer pStencilInputAttachmentIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.colorAttachmentCount(colorAttachmentCount);
        this.pColorAttachmentInputIndices(pColorAttachmentInputIndices);
        this.pDepthInputAttachmentIndex(pDepthInputAttachmentIndex);
        this.pStencilInputAttachmentIndex(pStencilInputAttachmentIndex);
        return this;
    }

    public VkRenderingInputAttachmentIndexInfo set(VkRenderingInputAttachmentIndexInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderingInputAttachmentIndexInfo malloc() {
        return new VkRenderingInputAttachmentIndexInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderingInputAttachmentIndexInfo calloc() {
        return new VkRenderingInputAttachmentIndexInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderingInputAttachmentIndexInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderingInputAttachmentIndexInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderingInputAttachmentIndexInfo create(long address) {
        return new VkRenderingInputAttachmentIndexInfo(address, null);
    }

    public static @Nullable VkRenderingInputAttachmentIndexInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderingInputAttachmentIndexInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderingInputAttachmentIndexInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingInputAttachmentIndexInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingInputAttachmentIndexInfo malloc(MemoryStack stack) {
        return new VkRenderingInputAttachmentIndexInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingInputAttachmentIndexInfo calloc(MemoryStack stack) {
        return new VkRenderingInputAttachmentIndexInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int ncolorAttachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORATTACHMENTCOUNT);
    }

    public static @Nullable IntBuffer npColorAttachmentInputIndices(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTINPUTINDICES), VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(struct));
    }

    public static @Nullable IntBuffer npDepthInputAttachmentIndex(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHINPUTATTACHMENTINDEX), capacity);
    }

    public static @Nullable IntBuffer npStencilInputAttachmentIndex(long struct, int capacity) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PSTENCILINPUTATTACHMENTINDEX), capacity);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachmentInputIndices(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTINPUTINDICES, MemoryUtil.memAddressSafe(value));
        if (value != null) {
            VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(struct, value.remaining());
        }
    }

    public static void npDepthInputAttachmentIndex(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHINPUTATTACHMENTINDEX, MemoryUtil.memAddressSafe(value));
    }

    public static void npStencilInputAttachmentIndex(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTENCILINPUTATTACHMENTINDEX, MemoryUtil.memAddressSafe(value));
    }

    static {
        Struct.Layout layout = VkRenderingInputAttachmentIndexInfo.__struct(VkRenderingInputAttachmentIndexInfo.__member(4), VkRenderingInputAttachmentIndexInfo.__member(POINTER_SIZE), VkRenderingInputAttachmentIndexInfo.__member(4), VkRenderingInputAttachmentIndexInfo.__member(POINTER_SIZE), VkRenderingInputAttachmentIndexInfo.__member(POINTER_SIZE), VkRenderingInputAttachmentIndexInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        COLORATTACHMENTCOUNT = layout.offsetof(2);
        PCOLORATTACHMENTINPUTINDICES = layout.offsetof(3);
        PDEPTHINPUTATTACHMENTINDEX = layout.offsetof(4);
        PSTENCILINPUTATTACHMENTINDEX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkRenderingInputAttachmentIndexInfo, Buffer>
    implements NativeResource {
        private static final VkRenderingInputAttachmentIndexInfo ELEMENT_FACTORY = VkRenderingInputAttachmentIndexInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkRenderingInputAttachmentIndexInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderingInputAttachmentIndexInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderingInputAttachmentIndexInfo.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pColorAttachmentInputIndices() {
            return VkRenderingInputAttachmentIndexInfo.npColorAttachmentInputIndices(this.address());
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pDepthInputAttachmentIndex(int capacity) {
            return VkRenderingInputAttachmentIndexInfo.npDepthInputAttachmentIndex(this.address(), capacity);
        }

        @NativeType(value="uint32_t const *")
        public @Nullable IntBuffer pStencilInputAttachmentIndex(int capacity) {
            return VkRenderingInputAttachmentIndexInfo.npStencilInputAttachmentIndex(this.address(), capacity);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingInputAttachmentIndexInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000232002);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingInputAttachmentIndexInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer colorAttachmentCount(@NativeType(value="uint32_t") int value) {
            VkRenderingInputAttachmentIndexInfo.ncolorAttachmentCount(this.address(), value);
            return this;
        }

        public Buffer pColorAttachmentInputIndices(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderingInputAttachmentIndexInfo.npColorAttachmentInputIndices(this.address(), value);
            return this;
        }

        public Buffer pDepthInputAttachmentIndex(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderingInputAttachmentIndexInfo.npDepthInputAttachmentIndex(this.address(), value);
            return this;
        }

        public Buffer pStencilInputAttachmentIndex(@NativeType(value="uint32_t const *") @Nullable IntBuffer value) {
            VkRenderingInputAttachmentIndexInfo.npStencilInputAttachmentIndex(this.address(), value);
            return this;
        }
    }
}

