/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkShaderResourceUsageAMD;

public class VkShaderStatisticsInfoAMD
extends Struct<VkShaderStatisticsInfoAMD> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SHADERSTAGEMASK;
    public static final int RESOURCEUSAGE;
    public static final int NUMPHYSICALVGPRS;
    public static final int NUMPHYSICALSGPRS;
    public static final int NUMAVAILABLEVGPRS;
    public static final int NUMAVAILABLESGPRS;
    public static final int COMPUTEWORKGROUPSIZE;

    protected VkShaderStatisticsInfoAMD(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkShaderStatisticsInfoAMD create(long address, @Nullable ByteBuffer container) {
        return new VkShaderStatisticsInfoAMD(address, container);
    }

    public VkShaderStatisticsInfoAMD(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkShaderStatisticsInfoAMD.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkShaderStageFlags")
    public int shaderStageMask() {
        return VkShaderStatisticsInfoAMD.nshaderStageMask(this.address());
    }

    public VkShaderResourceUsageAMD resourceUsage() {
        return VkShaderStatisticsInfoAMD.nresourceUsage(this.address());
    }

    @NativeType(value="uint32_t")
    public int numPhysicalVgprs() {
        return VkShaderStatisticsInfoAMD.nnumPhysicalVgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int numPhysicalSgprs() {
        return VkShaderStatisticsInfoAMD.nnumPhysicalSgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int numAvailableVgprs() {
        return VkShaderStatisticsInfoAMD.nnumAvailableVgprs(this.address());
    }

    @NativeType(value="uint32_t")
    public int numAvailableSgprs() {
        return VkShaderStatisticsInfoAMD.nnumAvailableSgprs(this.address());
    }

    @NativeType(value="uint32_t[3]")
    public IntBuffer computeWorkGroupSize() {
        return VkShaderStatisticsInfoAMD.ncomputeWorkGroupSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int computeWorkGroupSize(int index) {
        return VkShaderStatisticsInfoAMD.ncomputeWorkGroupSize(this.address(), index);
    }

    public static VkShaderStatisticsInfoAMD create(long address) {
        return new VkShaderStatisticsInfoAMD(address, null);
    }

    public static @Nullable VkShaderStatisticsInfoAMD createSafe(long address) {
        return address == 0L ? null : new VkShaderStatisticsInfoAMD(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static int nshaderStageMask(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SHADERSTAGEMASK);
    }

    public static VkShaderResourceUsageAMD nresourceUsage(long struct) {
        return VkShaderResourceUsageAMD.create(struct + (long)RESOURCEUSAGE);
    }

    public static int nnumPhysicalVgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMPHYSICALVGPRS);
    }

    public static int nnumPhysicalSgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMPHYSICALSGPRS);
    }

    public static int nnumAvailableVgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMAVAILABLEVGPRS);
    }

    public static int nnumAvailableSgprs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NUMAVAILABLESGPRS);
    }

    public static IntBuffer ncomputeWorkGroupSize(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)COMPUTEWORKGROUPSIZE, 3);
    }

    public static int ncomputeWorkGroupSize(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)COMPUTEWORKGROUPSIZE + Checks.check(index, 3) * 4L);
    }

    static {
        Struct.Layout layout = VkShaderStatisticsInfoAMD.__struct(VkShaderStatisticsInfoAMD.__member(4), VkShaderStatisticsInfoAMD.__member(VkShaderResourceUsageAMD.SIZEOF, VkShaderResourceUsageAMD.ALIGNOF), VkShaderStatisticsInfoAMD.__member(4), VkShaderStatisticsInfoAMD.__member(4), VkShaderStatisticsInfoAMD.__member(4), VkShaderStatisticsInfoAMD.__member(4), VkShaderStatisticsInfoAMD.__array(4, 3));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SHADERSTAGEMASK = layout.offsetof(0);
        RESOURCEUSAGE = layout.offsetof(1);
        NUMPHYSICALVGPRS = layout.offsetof(2);
        NUMPHYSICALSGPRS = layout.offsetof(3);
        NUMAVAILABLEVGPRS = layout.offsetof(4);
        NUMAVAILABLESGPRS = layout.offsetof(5);
        COMPUTEWORKGROUPSIZE = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkShaderStatisticsInfoAMD, Buffer> {
        private static final VkShaderStatisticsInfoAMD ELEMENT_FACTORY = VkShaderStatisticsInfoAMD.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkShaderStatisticsInfoAMD getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkShaderStageFlags")
        public int shaderStageMask() {
            return VkShaderStatisticsInfoAMD.nshaderStageMask(this.address());
        }

        public VkShaderResourceUsageAMD resourceUsage() {
            return VkShaderStatisticsInfoAMD.nresourceUsage(this.address());
        }

        @NativeType(value="uint32_t")
        public int numPhysicalVgprs() {
            return VkShaderStatisticsInfoAMD.nnumPhysicalVgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int numPhysicalSgprs() {
            return VkShaderStatisticsInfoAMD.nnumPhysicalSgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int numAvailableVgprs() {
            return VkShaderStatisticsInfoAMD.nnumAvailableVgprs(this.address());
        }

        @NativeType(value="uint32_t")
        public int numAvailableSgprs() {
            return VkShaderStatisticsInfoAMD.nnumAvailableSgprs(this.address());
        }

        @NativeType(value="uint32_t[3]")
        public IntBuffer computeWorkGroupSize() {
            return VkShaderStatisticsInfoAMD.ncomputeWorkGroupSize(this.address());
        }

        @NativeType(value="uint32_t")
        public int computeWorkGroupSize(int index) {
            return VkShaderStatisticsInfoAMD.ncomputeWorkGroupSize(this.address(), index);
        }
    }
}

