/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkSpecializationMapEntry;

public class VkSpecializationInfo
extends Struct<VkSpecializationInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAPENTRYCOUNT;
    public static final int PMAPENTRIES;
    public static final int DATASIZE;
    public static final int PDATA;

    protected VkSpecializationInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSpecializationInfo create(long address, @Nullable ByteBuffer container) {
        return new VkSpecializationInfo(address, container);
    }

    public VkSpecializationInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSpecializationInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int mapEntryCount() {
        return VkSpecializationInfo.nmapEntryCount(this.address());
    }

    @NativeType(value="VkSpecializationMapEntry const *")
    public @Nullable VkSpecializationMapEntry.Buffer pMapEntries() {
        return VkSpecializationInfo.npMapEntries(this.address());
    }

    @NativeType(value="size_t")
    public long dataSize() {
        return VkSpecializationInfo.ndataSize(this.address());
    }

    @NativeType(value="void const *")
    public @Nullable ByteBuffer pData() {
        return VkSpecializationInfo.npData(this.address());
    }

    public VkSpecializationInfo pMapEntries(@NativeType(value="VkSpecializationMapEntry const *") @Nullable VkSpecializationMapEntry.Buffer value) {
        VkSpecializationInfo.npMapEntries(this.address(), value);
        return this;
    }

    public VkSpecializationInfo pData(@NativeType(value="void const *") @Nullable ByteBuffer value) {
        VkSpecializationInfo.npData(this.address(), value);
        return this;
    }

    public VkSpecializationInfo set(@Nullable VkSpecializationMapEntry.Buffer pMapEntries, @Nullable ByteBuffer pData) {
        this.pMapEntries(pMapEntries);
        this.pData(pData);
        return this;
    }

    public VkSpecializationInfo set(VkSpecializationInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSpecializationInfo malloc() {
        return new VkSpecializationInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSpecializationInfo calloc() {
        return new VkSpecializationInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSpecializationInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSpecializationInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkSpecializationInfo create(long address) {
        return new VkSpecializationInfo(address, null);
    }

    public static @Nullable VkSpecializationInfo createSafe(long address) {
        return address == 0L ? null : new VkSpecializationInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSpecializationInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSpecializationInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSpecializationInfo mallocStack() {
        return VkSpecializationInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationInfo callocStack() {
        return VkSpecializationInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSpecializationInfo mallocStack(MemoryStack stack) {
        return VkSpecializationInfo.malloc(stack);
    }

    @Deprecated
    public static VkSpecializationInfo callocStack(MemoryStack stack) {
        return VkSpecializationInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSpecializationInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSpecializationInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSpecializationInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSpecializationInfo.calloc(capacity, stack);
    }

    public static VkSpecializationInfo malloc(MemoryStack stack) {
        return new VkSpecializationInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSpecializationInfo calloc(MemoryStack stack) {
        return new VkSpecializationInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmapEntryCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAPENTRYCOUNT);
    }

    public static @Nullable VkSpecializationMapEntry.Buffer npMapEntries(long struct) {
        return VkSpecializationMapEntry.createSafe(MemoryUtil.memGetAddress(struct + (long)PMAPENTRIES), VkSpecializationInfo.nmapEntryCount(struct));
    }

    public static long ndataSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)DATASIZE);
    }

    public static @Nullable ByteBuffer npData(long struct) {
        return MemoryUtil.memByteBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDATA), (int)VkSpecializationInfo.ndataSize(struct));
    }

    public static void nmapEntryCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)MAPENTRYCOUNT, value);
    }

    public static void npMapEntries(long struct, @Nullable VkSpecializationMapEntry.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PMAPENTRIES, MemoryUtil.memAddressSafe(value));
        VkSpecializationInfo.nmapEntryCount(struct, value == null ? 0 : value.remaining());
    }

    public static void ndataSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)DATASIZE, value);
    }

    public static void npData(long struct, @Nullable ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDATA, MemoryUtil.memAddressSafe(value));
        VkSpecializationInfo.ndataSize(struct, value == null ? 0L : (long)value.remaining());
    }

    public static void validate(long struct) {
        if (VkSpecializationInfo.nmapEntryCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PMAPENTRIES));
        }
        if (VkSpecializationInfo.ndataSize(struct) != 0L) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDATA));
        }
    }

    static {
        Struct.Layout layout = VkSpecializationInfo.__struct(VkSpecializationInfo.__member(4), VkSpecializationInfo.__member(POINTER_SIZE), VkSpecializationInfo.__member(POINTER_SIZE), VkSpecializationInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAPENTRYCOUNT = layout.offsetof(0);
        PMAPENTRIES = layout.offsetof(1);
        DATASIZE = layout.offsetof(2);
        PDATA = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkSpecializationInfo, Buffer>
    implements NativeResource {
        private static final VkSpecializationInfo ELEMENT_FACTORY = VkSpecializationInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSpecializationInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int mapEntryCount() {
            return VkSpecializationInfo.nmapEntryCount(this.address());
        }

        @NativeType(value="VkSpecializationMapEntry const *")
        public @Nullable VkSpecializationMapEntry.Buffer pMapEntries() {
            return VkSpecializationInfo.npMapEntries(this.address());
        }

        @NativeType(value="size_t")
        public long dataSize() {
            return VkSpecializationInfo.ndataSize(this.address());
        }

        @NativeType(value="void const *")
        public @Nullable ByteBuffer pData() {
            return VkSpecializationInfo.npData(this.address());
        }

        public Buffer pMapEntries(@NativeType(value="VkSpecializationMapEntry const *") @Nullable VkSpecializationMapEntry.Buffer value) {
            VkSpecializationInfo.npMapEntries(this.address(), value);
            return this;
        }

        public Buffer pData(@NativeType(value="void const *") @Nullable ByteBuffer value) {
            VkSpecializationInfo.npData(this.address(), value);
            return this;
        }
    }
}

