/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkSubpassEndInfo;

public class VkSubpassEndInfoKHR
extends VkSubpassEndInfo {
    protected VkSubpassEndInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubpassEndInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkSubpassEndInfoKHR(address, container);
    }

    public VkSubpassEndInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkSubpassEndInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkSubpassEndInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassEndInfoKHR sType$Default() {
        return this.sType(1000109006);
    }

    @Override
    public VkSubpassEndInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkSubpassEndInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkSubpassEndInfoKHR set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubpassEndInfoKHR set(VkSubpassEndInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubpassEndInfoKHR malloc() {
        return new VkSubpassEndInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubpassEndInfoKHR calloc() {
        return new VkSubpassEndInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubpassEndInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubpassEndInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkSubpassEndInfoKHR create(long address) {
        return new VkSubpassEndInfoKHR(address, null);
    }

    public static @Nullable VkSubpassEndInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkSubpassEndInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubpassEndInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubpassEndInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSubpassEndInfoKHR mallocStack() {
        return VkSubpassEndInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassEndInfoKHR callocStack() {
        return VkSubpassEndInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSubpassEndInfoKHR mallocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkSubpassEndInfoKHR callocStack(MemoryStack stack) {
        return VkSubpassEndInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSubpassEndInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSubpassEndInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSubpassEndInfoKHR.calloc(capacity, stack);
    }

    public static VkSubpassEndInfoKHR malloc(MemoryStack stack) {
        return new VkSubpassEndInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubpassEndInfoKHR calloc(MemoryStack stack) {
        return new VkSubpassEndInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkSubpassEndInfo.Buffer {
        private static final VkSubpassEndInfoKHR ELEMENT_FACTORY = VkSubpassEndInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSubpassEndInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubpassEndInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000109006);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSubpassEndInfoKHR.npNext(this.address(), value);
            return this;
        }
    }
}

