/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSubresourceHostMemcpySize
extends Struct<VkSubresourceHostMemcpySize>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SIZE;

    protected VkSubresourceHostMemcpySize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSubresourceHostMemcpySize create(long address, @Nullable ByteBuffer container) {
        return new VkSubresourceHostMemcpySize(address, container);
    }

    public VkSubresourceHostMemcpySize(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSubresourceHostMemcpySize.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSubresourceHostMemcpySize.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkSubresourceHostMemcpySize.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long size() {
        return VkSubresourceHostMemcpySize.nsize(this.address());
    }

    public VkSubresourceHostMemcpySize sType(@NativeType(value="VkStructureType") int value) {
        VkSubresourceHostMemcpySize.nsType(this.address(), value);
        return this;
    }

    public VkSubresourceHostMemcpySize sType$Default() {
        return this.sType(1000270008);
    }

    public VkSubresourceHostMemcpySize pNext(@NativeType(value="void *") long value) {
        VkSubresourceHostMemcpySize.npNext(this.address(), value);
        return this;
    }

    public VkSubresourceHostMemcpySize set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkSubresourceHostMemcpySize set(VkSubresourceHostMemcpySize src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSubresourceHostMemcpySize malloc() {
        return new VkSubresourceHostMemcpySize(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSubresourceHostMemcpySize calloc() {
        return new VkSubresourceHostMemcpySize(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSubresourceHostMemcpySize create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSubresourceHostMemcpySize(MemoryUtil.memAddress(container), container);
    }

    public static VkSubresourceHostMemcpySize create(long address) {
        return new VkSubresourceHostMemcpySize(address, null);
    }

    public static @Nullable VkSubresourceHostMemcpySize createSafe(long address) {
        return address == 0L ? null : new VkSubresourceHostMemcpySize(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSubresourceHostMemcpySize.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSubresourceHostMemcpySize.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSubresourceHostMemcpySize malloc(MemoryStack stack) {
        return new VkSubresourceHostMemcpySize(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSubresourceHostMemcpySize calloc(MemoryStack stack) {
        return new VkSubresourceHostMemcpySize(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIZE);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkSubresourceHostMemcpySize.__struct(VkSubresourceHostMemcpySize.__member(4), VkSubresourceHostMemcpySize.__member(POINTER_SIZE), VkSubresourceHostMemcpySize.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SIZE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkSubresourceHostMemcpySize, Buffer>
    implements NativeResource {
        private static final VkSubresourceHostMemcpySize ELEMENT_FACTORY = VkSubresourceHostMemcpySize.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSubresourceHostMemcpySize getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSubresourceHostMemcpySize.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkSubresourceHostMemcpySize.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long size() {
            return VkSubresourceHostMemcpySize.nsize(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSubresourceHostMemcpySize.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000270008);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkSubresourceHostMemcpySize.npNext(this.address(), value);
            return this;
        }
    }
}

