/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtent2D;

public class VkSurfaceCapabilitiesKHR
extends Struct<VkSurfaceCapabilitiesKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MINIMAGECOUNT;
    public static final int MAXIMAGECOUNT;
    public static final int CURRENTEXTENT;
    public static final int MINIMAGEEXTENT;
    public static final int MAXIMAGEEXTENT;
    public static final int MAXIMAGEARRAYLAYERS;
    public static final int SUPPORTEDTRANSFORMS;
    public static final int CURRENTTRANSFORM;
    public static final int SUPPORTEDCOMPOSITEALPHA;
    public static final int SUPPORTEDUSAGEFLAGS;

    protected VkSurfaceCapabilitiesKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSurfaceCapabilitiesKHR create(long address, @Nullable ByteBuffer container) {
        return new VkSurfaceCapabilitiesKHR(address, container);
    }

    public VkSurfaceCapabilitiesKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSurfaceCapabilitiesKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int minImageCount() {
        return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageCount() {
        return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
    }

    public VkExtent2D currentExtent() {
        return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
    }

    public VkExtent2D minImageExtent() {
        return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
    }

    public VkExtent2D maxImageExtent() {
        return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxImageArrayLayers() {
        return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagsKHR")
    public int supportedTransforms() {
        return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
    }

    @NativeType(value="VkSurfaceTransformFlagBitsKHR")
    public int currentTransform() {
        return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
    }

    @NativeType(value="VkCompositeAlphaFlagsKHR")
    public int supportedCompositeAlpha() {
        return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
    }

    @NativeType(value="VkImageUsageFlags")
    public int supportedUsageFlags() {
        return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
    }

    public static VkSurfaceCapabilitiesKHR malloc() {
        return new VkSurfaceCapabilitiesKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSurfaceCapabilitiesKHR calloc() {
        return new VkSurfaceCapabilitiesKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSurfaceCapabilitiesKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSurfaceCapabilitiesKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkSurfaceCapabilitiesKHR create(long address) {
        return new VkSurfaceCapabilitiesKHR(address, null);
    }

    public static @Nullable VkSurfaceCapabilitiesKHR createSafe(long address) {
        return address == 0L ? null : new VkSurfaceCapabilitiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSurfaceCapabilitiesKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSurfaceCapabilitiesKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR mallocStack() {
        return VkSurfaceCapabilitiesKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR callocStack() {
        return VkSurfaceCapabilitiesKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR mallocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.malloc(stack);
    }

    @Deprecated
    public static VkSurfaceCapabilitiesKHR callocStack(MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkSurfaceCapabilitiesKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkSurfaceCapabilitiesKHR.calloc(capacity, stack);
    }

    public static VkSurfaceCapabilitiesKHR malloc(MemoryStack stack) {
        return new VkSurfaceCapabilitiesKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSurfaceCapabilitiesKHR calloc(MemoryStack stack) {
        return new VkSurfaceCapabilitiesKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nminImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MINIMAGECOUNT);
    }

    public static int nmaxImageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGECOUNT);
    }

    public static VkExtent2D ncurrentExtent(long struct) {
        return VkExtent2D.create(struct + (long)CURRENTEXTENT);
    }

    public static VkExtent2D nminImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MINIMAGEEXTENT);
    }

    public static VkExtent2D nmaxImageExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXIMAGEEXTENT);
    }

    public static int nmaxImageArrayLayers(long struct) {
        return MemoryUtil.memGetInt(struct + (long)MAXIMAGEARRAYLAYERS);
    }

    public static int nsupportedTransforms(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDTRANSFORMS);
    }

    public static int ncurrentTransform(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTTRANSFORM);
    }

    public static int nsupportedCompositeAlpha(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDCOMPOSITEALPHA);
    }

    public static int nsupportedUsageFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUPPORTEDUSAGEFLAGS);
    }

    static {
        Struct.Layout layout = VkSurfaceCapabilitiesKHR.__struct(VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4), VkSurfaceCapabilitiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MINIMAGECOUNT = layout.offsetof(0);
        MAXIMAGECOUNT = layout.offsetof(1);
        CURRENTEXTENT = layout.offsetof(2);
        MINIMAGEEXTENT = layout.offsetof(3);
        MAXIMAGEEXTENT = layout.offsetof(4);
        MAXIMAGEARRAYLAYERS = layout.offsetof(5);
        SUPPORTEDTRANSFORMS = layout.offsetof(6);
        CURRENTTRANSFORM = layout.offsetof(7);
        SUPPORTEDCOMPOSITEALPHA = layout.offsetof(8);
        SUPPORTEDUSAGEFLAGS = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkSurfaceCapabilitiesKHR, Buffer>
    implements NativeResource {
        private static final VkSurfaceCapabilitiesKHR ELEMENT_FACTORY = VkSurfaceCapabilitiesKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkSurfaceCapabilitiesKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int minImageCount() {
            return VkSurfaceCapabilitiesKHR.nminImageCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageCount() {
            return VkSurfaceCapabilitiesKHR.nmaxImageCount(this.address());
        }

        public VkExtent2D currentExtent() {
            return VkSurfaceCapabilitiesKHR.ncurrentExtent(this.address());
        }

        public VkExtent2D minImageExtent() {
            return VkSurfaceCapabilitiesKHR.nminImageExtent(this.address());
        }

        public VkExtent2D maxImageExtent() {
            return VkSurfaceCapabilitiesKHR.nmaxImageExtent(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxImageArrayLayers() {
            return VkSurfaceCapabilitiesKHR.nmaxImageArrayLayers(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagsKHR")
        public int supportedTransforms() {
            return VkSurfaceCapabilitiesKHR.nsupportedTransforms(this.address());
        }

        @NativeType(value="VkSurfaceTransformFlagBitsKHR")
        public int currentTransform() {
            return VkSurfaceCapabilitiesKHR.ncurrentTransform(this.address());
        }

        @NativeType(value="VkCompositeAlphaFlagsKHR")
        public int supportedCompositeAlpha() {
            return VkSurfaceCapabilitiesKHR.nsupportedCompositeAlpha(this.address());
        }

        @NativeType(value="VkImageUsageFlags")
        public int supportedUsageFlags() {
            return VkSurfaceCapabilitiesKHR.nsupportedUsageFlags(this.address());
        }
    }
}

