/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkVideoEncodeRateControlLayerInfoKHR;

public class VkVideoEncodeRateControlInfoKHR
extends Struct<VkVideoEncodeRateControlInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RATECONTROLMODE;
    public static final int LAYERCOUNT;
    public static final int PLAYERS;
    public static final int VIRTUALBUFFERSIZEINMS;
    public static final int INITIALVIRTUALBUFFERSIZEINMS;

    protected VkVideoEncodeRateControlInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoEncodeRateControlInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoEncodeRateControlInfoKHR(address, container);
    }

    public VkVideoEncodeRateControlInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoEncodeRateControlInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoEncodeRateControlInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoEncodeRateControlInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlFlagsKHR")
    public int flags() {
        return VkVideoEncodeRateControlInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR")
    public int rateControlMode() {
        return VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkVideoEncodeRateControlInfoKHR.nlayerCount(this.address());
    }

    @NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *")
    public @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayers() {
        return VkVideoEncodeRateControlInfoKHR.npLayers(this.address());
    }

    @NativeType(value="uint32_t")
    public int virtualBufferSizeInMs() {
        return VkVideoEncodeRateControlInfoKHR.nvirtualBufferSizeInMs(this.address());
    }

    @NativeType(value="uint32_t")
    public int initialVirtualBufferSizeInMs() {
        return VkVideoEncodeRateControlInfoKHR.ninitialVirtualBufferSizeInMs(this.address());
    }

    public VkVideoEncodeRateControlInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoEncodeRateControlInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR sType$Default() {
        return this.sType(1000299001);
    }

    public VkVideoEncodeRateControlInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoEncodeRateControlInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR flags(@NativeType(value="VkVideoEncodeRateControlFlagsKHR") int value) {
        VkVideoEncodeRateControlInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR rateControlMode(@NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR") int value) {
        VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR pLayers(@NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *") @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
        VkVideoEncodeRateControlInfoKHR.npLayers(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR virtualBufferSizeInMs(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeRateControlInfoKHR.nvirtualBufferSizeInMs(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR initialVirtualBufferSizeInMs(@NativeType(value="uint32_t") int value) {
        VkVideoEncodeRateControlInfoKHR.ninitialVirtualBufferSizeInMs(this.address(), value);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR set(int sType, long pNext, int flags, int rateControlMode, @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayers, int virtualBufferSizeInMs, int initialVirtualBufferSizeInMs) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.rateControlMode(rateControlMode);
        this.pLayers(pLayers);
        this.virtualBufferSizeInMs(virtualBufferSizeInMs);
        this.initialVirtualBufferSizeInMs(initialVirtualBufferSizeInMs);
        return this;
    }

    public VkVideoEncodeRateControlInfoKHR set(VkVideoEncodeRateControlInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoEncodeRateControlInfoKHR malloc() {
        return new VkVideoEncodeRateControlInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoEncodeRateControlInfoKHR calloc() {
        return new VkVideoEncodeRateControlInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoEncodeRateControlInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoEncodeRateControlInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoEncodeRateControlInfoKHR create(long address) {
        return new VkVideoEncodeRateControlInfoKHR(address, null);
    }

    public static @Nullable VkVideoEncodeRateControlInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoEncodeRateControlInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoEncodeRateControlInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoEncodeRateControlInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoEncodeRateControlInfoKHR malloc(MemoryStack stack) {
        return new VkVideoEncodeRateControlInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoEncodeRateControlInfoKHR calloc(MemoryStack stack) {
        return new VkVideoEncodeRateControlInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nrateControlMode(long struct) {
        return MemoryUtil.memGetInt(struct + (long)RATECONTROLMODE);
    }

    public static int nlayerCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LAYERCOUNT);
    }

    public static @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer npLayers(long struct) {
        return VkVideoEncodeRateControlLayerInfoKHR.createSafe(MemoryUtil.memGetAddress(struct + (long)PLAYERS), VkVideoEncodeRateControlInfoKHR.nlayerCount(struct));
    }

    public static int nvirtualBufferSizeInMs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)VIRTUALBUFFERSIZEINMS);
    }

    public static int ninitialVirtualBufferSizeInMs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)INITIALVIRTUALBUFFERSIZEINMS);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nrateControlMode(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)RATECONTROLMODE, value);
    }

    public static void nlayerCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)LAYERCOUNT, value);
    }

    public static void npLayers(long struct, @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PLAYERS, MemoryUtil.memAddressSafe(value));
        VkVideoEncodeRateControlInfoKHR.nlayerCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nvirtualBufferSizeInMs(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)VIRTUALBUFFERSIZEINMS, value);
    }

    public static void ninitialVirtualBufferSizeInMs(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)INITIALVIRTUALBUFFERSIZEINMS, value);
    }

    public static void validate(long struct) {
        if (VkVideoEncodeRateControlInfoKHR.nlayerCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PLAYERS));
        }
    }

    static {
        Struct.Layout layout = VkVideoEncodeRateControlInfoKHR.__struct(VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(POINTER_SIZE), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(POINTER_SIZE), VkVideoEncodeRateControlInfoKHR.__member(4), VkVideoEncodeRateControlInfoKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RATECONTROLMODE = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
        PLAYERS = layout.offsetof(5);
        VIRTUALBUFFERSIZEINMS = layout.offsetof(6);
        INITIALVIRTUALBUFFERSIZEINMS = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkVideoEncodeRateControlInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoEncodeRateControlInfoKHR ELEMENT_FACTORY = VkVideoEncodeRateControlInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected VkVideoEncodeRateControlInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoEncodeRateControlInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoEncodeRateControlInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlFlagsKHR")
        public int flags() {
            return VkVideoEncodeRateControlInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR")
        public int rateControlMode() {
            return VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkVideoEncodeRateControlInfoKHR.nlayerCount(this.address());
        }

        @NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *")
        public @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer pLayers() {
            return VkVideoEncodeRateControlInfoKHR.npLayers(this.address());
        }

        @NativeType(value="uint32_t")
        public int virtualBufferSizeInMs() {
            return VkVideoEncodeRateControlInfoKHR.nvirtualBufferSizeInMs(this.address());
        }

        @NativeType(value="uint32_t")
        public int initialVirtualBufferSizeInMs() {
            return VkVideoEncodeRateControlInfoKHR.ninitialVirtualBufferSizeInMs(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoEncodeRateControlInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000299001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoEncodeRateControlInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkVideoEncodeRateControlFlagsKHR") int value) {
            VkVideoEncodeRateControlInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer rateControlMode(@NativeType(value="VkVideoEncodeRateControlModeFlagBitsKHR") int value) {
            VkVideoEncodeRateControlInfoKHR.nrateControlMode(this.address(), value);
            return this;
        }

        public Buffer pLayers(@NativeType(value="VkVideoEncodeRateControlLayerInfoKHR const *") @Nullable VkVideoEncodeRateControlLayerInfoKHR.Buffer value) {
            VkVideoEncodeRateControlInfoKHR.npLayers(this.address(), value);
            return this;
        }

        public Buffer virtualBufferSizeInMs(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeRateControlInfoKHR.nvirtualBufferSizeInMs(this.address(), value);
            return this;
        }

        public Buffer initialVirtualBufferSizeInMs(@NativeType(value="uint32_t") int value) {
            VkVideoEncodeRateControlInfoKHR.ninitialVirtualBufferSizeInMs(this.address(), value);
            return this;
        }
    }
}

