/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1QuantizationFlags;

public class StdVideoAV1Quantization
extends Struct<StdVideoAV1Quantization>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int BASE_Q_IDX;
    public static final int DELTAQYDC;
    public static final int DELTAQUDC;
    public static final int DELTAQUAC;
    public static final int DELTAQVDC;
    public static final int DELTAQVAC;
    public static final int QM_Y;
    public static final int QM_U;
    public static final int QM_V;

    protected StdVideoAV1Quantization(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoAV1Quantization create(long address, @Nullable ByteBuffer container) {
        return new StdVideoAV1Quantization(address, container);
    }

    public StdVideoAV1Quantization(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoAV1Quantization.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoAV1QuantizationFlags flags() {
        return StdVideoAV1Quantization.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte base_q_idx() {
        return StdVideoAV1Quantization.nbase_q_idx(this.address());
    }

    @NativeType(value="int8_t")
    public byte DeltaQYDc() {
        return StdVideoAV1Quantization.nDeltaQYDc(this.address());
    }

    @NativeType(value="int8_t")
    public byte DeltaQUDc() {
        return StdVideoAV1Quantization.nDeltaQUDc(this.address());
    }

    @NativeType(value="int8_t")
    public byte DeltaQUAc() {
        return StdVideoAV1Quantization.nDeltaQUAc(this.address());
    }

    @NativeType(value="int8_t")
    public byte DeltaQVDc() {
        return StdVideoAV1Quantization.nDeltaQVDc(this.address());
    }

    @NativeType(value="int8_t")
    public byte DeltaQVAc() {
        return StdVideoAV1Quantization.nDeltaQVAc(this.address());
    }

    @NativeType(value="uint8_t")
    public byte qm_y() {
        return StdVideoAV1Quantization.nqm_y(this.address());
    }

    @NativeType(value="uint8_t")
    public byte qm_u() {
        return StdVideoAV1Quantization.nqm_u(this.address());
    }

    @NativeType(value="uint8_t")
    public byte qm_v() {
        return StdVideoAV1Quantization.nqm_v(this.address());
    }

    public StdVideoAV1Quantization flags(StdVideoAV1QuantizationFlags value) {
        StdVideoAV1Quantization.nflags(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization flags(Consumer<StdVideoAV1QuantizationFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoAV1Quantization base_q_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1Quantization.nbase_q_idx(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization DeltaQYDc(@NativeType(value="int8_t") byte value) {
        StdVideoAV1Quantization.nDeltaQYDc(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization DeltaQUDc(@NativeType(value="int8_t") byte value) {
        StdVideoAV1Quantization.nDeltaQUDc(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization DeltaQUAc(@NativeType(value="int8_t") byte value) {
        StdVideoAV1Quantization.nDeltaQUAc(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization DeltaQVDc(@NativeType(value="int8_t") byte value) {
        StdVideoAV1Quantization.nDeltaQVDc(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization DeltaQVAc(@NativeType(value="int8_t") byte value) {
        StdVideoAV1Quantization.nDeltaQVAc(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization qm_y(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1Quantization.nqm_y(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization qm_u(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1Quantization.nqm_u(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization qm_v(@NativeType(value="uint8_t") byte value) {
        StdVideoAV1Quantization.nqm_v(this.address(), value);
        return this;
    }

    public StdVideoAV1Quantization set(StdVideoAV1QuantizationFlags flags, byte base_q_idx, byte DeltaQYDc, byte DeltaQUDc, byte DeltaQUAc, byte DeltaQVDc, byte DeltaQVAc, byte qm_y, byte qm_u, byte qm_v) {
        this.flags(flags);
        this.base_q_idx(base_q_idx);
        this.DeltaQYDc(DeltaQYDc);
        this.DeltaQUDc(DeltaQUDc);
        this.DeltaQUAc(DeltaQUAc);
        this.DeltaQVDc(DeltaQVDc);
        this.DeltaQVAc(DeltaQVAc);
        this.qm_y(qm_y);
        this.qm_u(qm_u);
        this.qm_v(qm_v);
        return this;
    }

    public StdVideoAV1Quantization set(StdVideoAV1Quantization src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoAV1Quantization malloc() {
        return new StdVideoAV1Quantization(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoAV1Quantization calloc() {
        return new StdVideoAV1Quantization(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoAV1Quantization create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoAV1Quantization(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoAV1Quantization create(long address) {
        return new StdVideoAV1Quantization(address, null);
    }

    public static @Nullable StdVideoAV1Quantization createSafe(long address) {
        return address == 0L ? null : new StdVideoAV1Quantization(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoAV1Quantization.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoAV1Quantization.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoAV1Quantization malloc(MemoryStack stack) {
        return new StdVideoAV1Quantization(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoAV1Quantization calloc(MemoryStack stack) {
        return new StdVideoAV1Quantization(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoAV1QuantizationFlags nflags(long struct) {
        return StdVideoAV1QuantizationFlags.create(struct + (long)FLAGS);
    }

    public static byte nbase_q_idx(long struct) {
        return MemoryUtil.memGetByte(struct + (long)BASE_Q_IDX);
    }

    public static byte nDeltaQYDc(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DELTAQYDC);
    }

    public static byte nDeltaQUDc(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DELTAQUDC);
    }

    public static byte nDeltaQUAc(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DELTAQUAC);
    }

    public static byte nDeltaQVDc(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DELTAQVDC);
    }

    public static byte nDeltaQVAc(long struct) {
        return MemoryUtil.memGetByte(struct + (long)DELTAQVAC);
    }

    public static byte nqm_y(long struct) {
        return MemoryUtil.memGetByte(struct + (long)QM_Y);
    }

    public static byte nqm_u(long struct) {
        return MemoryUtil.memGetByte(struct + (long)QM_U);
    }

    public static byte nqm_v(long struct) {
        return MemoryUtil.memGetByte(struct + (long)QM_V);
    }

    public static void nflags(long struct, StdVideoAV1QuantizationFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoAV1QuantizationFlags.SIZEOF);
    }

    public static void nbase_q_idx(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)BASE_Q_IDX, value);
    }

    public static void nDeltaQYDc(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTAQYDC, value);
    }

    public static void nDeltaQUDc(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTAQUDC, value);
    }

    public static void nDeltaQUAc(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTAQUAC, value);
    }

    public static void nDeltaQVDc(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTAQVDC, value);
    }

    public static void nDeltaQVAc(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)DELTAQVAC, value);
    }

    public static void nqm_y(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)QM_Y, value);
    }

    public static void nqm_u(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)QM_U, value);
    }

    public static void nqm_v(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)QM_V, value);
    }

    static {
        Struct.Layout layout = StdVideoAV1Quantization.__struct(StdVideoAV1Quantization.__member(StdVideoAV1QuantizationFlags.SIZEOF, StdVideoAV1QuantizationFlags.ALIGNOF), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1), StdVideoAV1Quantization.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        BASE_Q_IDX = layout.offsetof(1);
        DELTAQYDC = layout.offsetof(2);
        DELTAQUDC = layout.offsetof(3);
        DELTAQUAC = layout.offsetof(4);
        DELTAQVDC = layout.offsetof(5);
        DELTAQVAC = layout.offsetof(6);
        QM_Y = layout.offsetof(7);
        QM_U = layout.offsetof(8);
        QM_V = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<StdVideoAV1Quantization, Buffer>
    implements NativeResource {
        private static final StdVideoAV1Quantization ELEMENT_FACTORY = StdVideoAV1Quantization.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected StdVideoAV1Quantization getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoAV1QuantizationFlags flags() {
            return StdVideoAV1Quantization.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte base_q_idx() {
            return StdVideoAV1Quantization.nbase_q_idx(this.address());
        }

        @NativeType(value="int8_t")
        public byte DeltaQYDc() {
            return StdVideoAV1Quantization.nDeltaQYDc(this.address());
        }

        @NativeType(value="int8_t")
        public byte DeltaQUDc() {
            return StdVideoAV1Quantization.nDeltaQUDc(this.address());
        }

        @NativeType(value="int8_t")
        public byte DeltaQUAc() {
            return StdVideoAV1Quantization.nDeltaQUAc(this.address());
        }

        @NativeType(value="int8_t")
        public byte DeltaQVDc() {
            return StdVideoAV1Quantization.nDeltaQVDc(this.address());
        }

        @NativeType(value="int8_t")
        public byte DeltaQVAc() {
            return StdVideoAV1Quantization.nDeltaQVAc(this.address());
        }

        @NativeType(value="uint8_t")
        public byte qm_y() {
            return StdVideoAV1Quantization.nqm_y(this.address());
        }

        @NativeType(value="uint8_t")
        public byte qm_u() {
            return StdVideoAV1Quantization.nqm_u(this.address());
        }

        @NativeType(value="uint8_t")
        public byte qm_v() {
            return StdVideoAV1Quantization.nqm_v(this.address());
        }

        public Buffer flags(StdVideoAV1QuantizationFlags value) {
            StdVideoAV1Quantization.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoAV1QuantizationFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer base_q_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1Quantization.nbase_q_idx(this.address(), value);
            return this;
        }

        public Buffer DeltaQYDc(@NativeType(value="int8_t") byte value) {
            StdVideoAV1Quantization.nDeltaQYDc(this.address(), value);
            return this;
        }

        public Buffer DeltaQUDc(@NativeType(value="int8_t") byte value) {
            StdVideoAV1Quantization.nDeltaQUDc(this.address(), value);
            return this;
        }

        public Buffer DeltaQUAc(@NativeType(value="int8_t") byte value) {
            StdVideoAV1Quantization.nDeltaQUAc(this.address(), value);
            return this;
        }

        public Buffer DeltaQVDc(@NativeType(value="int8_t") byte value) {
            StdVideoAV1Quantization.nDeltaQVDc(this.address(), value);
            return this;
        }

        public Buffer DeltaQVAc(@NativeType(value="int8_t") byte value) {
            StdVideoAV1Quantization.nDeltaQVAc(this.address(), value);
            return this;
        }

        public Buffer qm_y(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1Quantization.nqm_y(this.address(), value);
            return this;
        }

        public Buffer qm_u(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1Quantization.nqm_u(this.address(), value);
            return this;
        }

        public Buffer qm_v(@NativeType(value="uint8_t") byte value) {
            StdVideoAV1Quantization.nqm_v(this.address(), value);
            return this;
        }
    }
}

