/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265ReferenceInfoFlags;

public class StdVideoEncodeH265ReferenceInfo
extends Struct<StdVideoEncodeH265ReferenceInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int PIC_TYPE;
    public static final int PICORDERCNTVAL;
    public static final int TEMPORALID;

    protected StdVideoEncodeH265ReferenceInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeH265ReferenceInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265ReferenceInfo(address, container);
    }

    public StdVideoEncodeH265ReferenceInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH265ReferenceInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH265ReferenceInfoFlags flags() {
        return StdVideoEncodeH265ReferenceInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoH265PictureType")
    public int pic_type() {
        return StdVideoEncodeH265ReferenceInfo.npic_type(this.address());
    }

    @NativeType(value="int32_t")
    public int PicOrderCntVal() {
        return StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address());
    }

    @NativeType(value="uint8_t")
    public byte TemporalId() {
        return StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address());
    }

    public StdVideoEncodeH265ReferenceInfo flags(StdVideoEncodeH265ReferenceInfoFlags value) {
        StdVideoEncodeH265ReferenceInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo flags(Consumer<StdVideoEncodeH265ReferenceInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo pic_type(@NativeType(value="StdVideoH265PictureType") int value) {
        StdVideoEncodeH265ReferenceInfo.npic_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo PicOrderCntVal(@NativeType(value="int32_t") int value) {
        StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo TemporalId(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo set(StdVideoEncodeH265ReferenceInfoFlags flags, int pic_type, int PicOrderCntVal, byte TemporalId) {
        this.flags(flags);
        this.pic_type(pic_type);
        this.PicOrderCntVal(PicOrderCntVal);
        this.TemporalId(TemporalId);
        return this;
    }

    public StdVideoEncodeH265ReferenceInfo set(StdVideoEncodeH265ReferenceInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265ReferenceInfo malloc() {
        return new StdVideoEncodeH265ReferenceInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceInfo calloc() {
        return new StdVideoEncodeH265ReferenceInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeH265ReferenceInfo(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH265ReferenceInfo create(long address) {
        return new StdVideoEncodeH265ReferenceInfo(address, null);
    }

    public static @Nullable StdVideoEncodeH265ReferenceInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265ReferenceInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeH265ReferenceInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265ReferenceInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265ReferenceInfo malloc(MemoryStack stack) {
        return new StdVideoEncodeH265ReferenceInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceInfo calloc(MemoryStack stack) {
        return new StdVideoEncodeH265ReferenceInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH265ReferenceInfoFlags nflags(long struct) {
        return StdVideoEncodeH265ReferenceInfoFlags.create(struct + (long)FLAGS);
    }

    public static int npic_type(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PIC_TYPE);
    }

    public static int nPicOrderCntVal(long struct) {
        return MemoryUtil.memGetInt(struct + (long)PICORDERCNTVAL);
    }

    public static byte nTemporalId(long struct) {
        return MemoryUtil.memGetByte(struct + (long)TEMPORALID);
    }

    public static void nflags(long struct, StdVideoEncodeH265ReferenceInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH265ReferenceInfoFlags.SIZEOF);
    }

    public static void npic_type(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PIC_TYPE, value);
    }

    public static void nPicOrderCntVal(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)PICORDERCNTVAL, value);
    }

    public static void nTemporalId(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)TEMPORALID, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265ReferenceInfo.__struct(StdVideoEncodeH265ReferenceInfo.__member(StdVideoEncodeH265ReferenceInfoFlags.SIZEOF, StdVideoEncodeH265ReferenceInfoFlags.ALIGNOF), StdVideoEncodeH265ReferenceInfo.__member(4), StdVideoEncodeH265ReferenceInfo.__member(4), StdVideoEncodeH265ReferenceInfo.__member(1));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        PIC_TYPE = layout.offsetof(1);
        PICORDERCNTVAL = layout.offsetof(2);
        TEMPORALID = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265ReferenceInfo, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265ReferenceInfo ELEMENT_FACTORY = StdVideoEncodeH265ReferenceInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected StdVideoEncodeH265ReferenceInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH265ReferenceInfoFlags flags() {
            return StdVideoEncodeH265ReferenceInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoH265PictureType")
        public int pic_type() {
            return StdVideoEncodeH265ReferenceInfo.npic_type(this.address());
        }

        @NativeType(value="int32_t")
        public int PicOrderCntVal() {
            return StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address());
        }

        @NativeType(value="uint8_t")
        public byte TemporalId() {
            return StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address());
        }

        public Buffer flags(StdVideoEncodeH265ReferenceInfoFlags value) {
            StdVideoEncodeH265ReferenceInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265ReferenceInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer pic_type(@NativeType(value="StdVideoH265PictureType") int value) {
            StdVideoEncodeH265ReferenceInfo.npic_type(this.address(), value);
            return this;
        }

        public Buffer PicOrderCntVal(@NativeType(value="int32_t") int value) {
            StdVideoEncodeH265ReferenceInfo.nPicOrderCntVal(this.address(), value);
            return this;
        }

        public Buffer TemporalId(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceInfo.nTemporalId(this.address(), value);
            return this;
        }
    }
}

