/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265ReferenceModificationFlags;

public class StdVideoEncodeH265ReferenceModifications
extends Struct<StdVideoEncodeH265ReferenceModifications>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int NUM_REF_IDX_L0_ACTIVE_MINUS1;
    public static final int NUM_REF_IDX_L1_ACTIVE_MINUS1;
    public static final int RESERVED1;
    public static final int REFPICLIST0;
    public static final int REFPICLIST1;
    public static final int LIST_ENTRY_L0;
    public static final int LIST_ENTRY_L1;

    protected StdVideoEncodeH265ReferenceModifications(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeH265ReferenceModifications create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265ReferenceModifications(address, container);
    }

    public StdVideoEncodeH265ReferenceModifications(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH265ReferenceModifications.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH265ReferenceModificationFlags flags() {
        return StdVideoEncodeH265ReferenceModifications.nflags(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l0_active_minus1() {
        return StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l0_active_minus1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte num_ref_idx_l1_active_minus1() {
        return StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l1_active_minus1(this.address());
    }

    @NativeType(value="uint16_t")
    public short reserved1() {
        return StdVideoEncodeH265ReferenceModifications.nreserved1(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
    public ByteBuffer RefPicList0() {
        return StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicList0(int index) {
        return StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
    public ByteBuffer RefPicList1() {
        return StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte RefPicList1(int index) {
        return StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
    public ByteBuffer list_entry_l0() {
        return StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address());
    }

    @NativeType(value="uint8_t")
    public byte list_entry_l0(int index) {
        return StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), index);
    }

    @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
    public ByteBuffer list_entry_l1() {
        return StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address());
    }

    @NativeType(value="uint8_t")
    public byte list_entry_l1(int index) {
        return StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), index);
    }

    public StdVideoEncodeH265ReferenceModifications flags(StdVideoEncodeH265ReferenceModificationFlags value) {
        StdVideoEncodeH265ReferenceModifications.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications flags(Consumer<StdVideoEncodeH265ReferenceModificationFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l0_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l1_active_minus1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications reserved1(@NativeType(value="uint16_t") short value) {
        StdVideoEncodeH265ReferenceModifications.nreserved1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications RefPicList0(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications RefPicList0(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications RefPicList1(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications RefPicList1(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications list_entry_l0(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications list_entry_l0(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications list_entry_l1(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
        StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications list_entry_l1(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), index, value);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications set(StdVideoEncodeH265ReferenceModificationFlags flags, byte num_ref_idx_l0_active_minus1, byte num_ref_idx_l1_active_minus1, short reserved1, ByteBuffer RefPicList0, ByteBuffer RefPicList1, ByteBuffer list_entry_l0, ByteBuffer list_entry_l1) {
        this.flags(flags);
        this.num_ref_idx_l0_active_minus1(num_ref_idx_l0_active_minus1);
        this.num_ref_idx_l1_active_minus1(num_ref_idx_l1_active_minus1);
        this.reserved1(reserved1);
        this.RefPicList0(RefPicList0);
        this.RefPicList1(RefPicList1);
        this.list_entry_l0(list_entry_l0);
        this.list_entry_l1(list_entry_l1);
        return this;
    }

    public StdVideoEncodeH265ReferenceModifications set(StdVideoEncodeH265ReferenceModifications src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265ReferenceModifications malloc() {
        return new StdVideoEncodeH265ReferenceModifications(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceModifications calloc() {
        return new StdVideoEncodeH265ReferenceModifications(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceModifications create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeH265ReferenceModifications(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH265ReferenceModifications create(long address) {
        return new StdVideoEncodeH265ReferenceModifications(address, null);
    }

    public static @Nullable StdVideoEncodeH265ReferenceModifications createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265ReferenceModifications(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeH265ReferenceModifications.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265ReferenceModifications.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265ReferenceModifications malloc(MemoryStack stack) {
        return new StdVideoEncodeH265ReferenceModifications(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265ReferenceModifications calloc(MemoryStack stack) {
        return new StdVideoEncodeH265ReferenceModifications(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH265ReferenceModificationFlags nflags(long struct) {
        return StdVideoEncodeH265ReferenceModificationFlags.create(struct + (long)FLAGS);
    }

    public static byte nnum_ref_idx_l0_active_minus1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1);
    }

    public static byte nnum_ref_idx_l1_active_minus1(long struct) {
        return MemoryUtil.memGetByte(struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1);
    }

    public static short nreserved1(long struct) {
        return MemoryUtil.memGetShort(struct + (long)RESERVED1);
    }

    public static ByteBuffer nRefPicList0(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)REFPICLIST0, 15);
    }

    public static byte nRefPicList0(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)REFPICLIST0 + Checks.check(index, 15) * 1L);
    }

    public static ByteBuffer nRefPicList1(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)REFPICLIST1, 15);
    }

    public static byte nRefPicList1(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)REFPICLIST1 + Checks.check(index, 15) * 1L);
    }

    public static ByteBuffer nlist_entry_l0(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LIST_ENTRY_L0, 15);
    }

    public static byte nlist_entry_l0(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)LIST_ENTRY_L0 + Checks.check(index, 15) * 1L);
    }

    public static ByteBuffer nlist_entry_l1(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)LIST_ENTRY_L1, 15);
    }

    public static byte nlist_entry_l1(long struct, int index) {
        return MemoryUtil.memGetByte(struct + (long)LIST_ENTRY_L1 + Checks.check(index, 15) * 1L);
    }

    public static void nflags(long struct, StdVideoEncodeH265ReferenceModificationFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH265ReferenceModificationFlags.SIZEOF);
    }

    public static void nnum_ref_idx_l0_active_minus1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)NUM_REF_IDX_L0_ACTIVE_MINUS1, value);
    }

    public static void nnum_ref_idx_l1_active_minus1(long struct, byte value) {
        MemoryUtil.memPutByte(struct + (long)NUM_REF_IDX_L1_ACTIVE_MINUS1, value);
    }

    public static void nreserved1(long struct, short value) {
        MemoryUtil.memPutShort(struct + (long)RESERVED1, value);
    }

    public static void nRefPicList0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)REFPICLIST0, value.remaining() * 1);
    }

    public static void nRefPicList0(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)REFPICLIST0 + Checks.check(index, 15) * 1L, value);
    }

    public static void nRefPicList1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)REFPICLIST1, value.remaining() * 1);
    }

    public static void nRefPicList1(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)REFPICLIST1 + Checks.check(index, 15) * 1L, value);
    }

    public static void nlist_entry_l0(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LIST_ENTRY_L0, value.remaining() * 1);
    }

    public static void nlist_entry_l0(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)LIST_ENTRY_L0 + Checks.check(index, 15) * 1L, value);
    }

    public static void nlist_entry_l1(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 15);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)LIST_ENTRY_L1, value.remaining() * 1);
    }

    public static void nlist_entry_l1(long struct, int index, byte value) {
        MemoryUtil.memPutByte(struct + (long)LIST_ENTRY_L1 + Checks.check(index, 15) * 1L, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265ReferenceModifications.__struct(StdVideoEncodeH265ReferenceModifications.__member(StdVideoEncodeH265ReferenceModificationFlags.SIZEOF, StdVideoEncodeH265ReferenceModificationFlags.ALIGNOF), StdVideoEncodeH265ReferenceModifications.__member(1), StdVideoEncodeH265ReferenceModifications.__member(1), StdVideoEncodeH265ReferenceModifications.__member(2), StdVideoEncodeH265ReferenceModifications.__array(1, 15), StdVideoEncodeH265ReferenceModifications.__array(1, 15), StdVideoEncodeH265ReferenceModifications.__array(1, 15), StdVideoEncodeH265ReferenceModifications.__array(1, 15));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        NUM_REF_IDX_L0_ACTIVE_MINUS1 = layout.offsetof(1);
        NUM_REF_IDX_L1_ACTIVE_MINUS1 = layout.offsetof(2);
        RESERVED1 = layout.offsetof(3);
        REFPICLIST0 = layout.offsetof(4);
        REFPICLIST1 = layout.offsetof(5);
        LIST_ENTRY_L0 = layout.offsetof(6);
        LIST_ENTRY_L1 = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265ReferenceModifications, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265ReferenceModifications ELEMENT_FACTORY = StdVideoEncodeH265ReferenceModifications.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        @Override
        protected StdVideoEncodeH265ReferenceModifications getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH265ReferenceModificationFlags flags() {
            return StdVideoEncodeH265ReferenceModifications.nflags(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l0_active_minus1() {
            return StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l0_active_minus1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte num_ref_idx_l1_active_minus1() {
            return StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l1_active_minus1(this.address());
        }

        @NativeType(value="uint16_t")
        public short reserved1() {
            return StdVideoEncodeH265ReferenceModifications.nreserved1(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
        public ByteBuffer RefPicList0() {
            return StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicList0(int index) {
            return StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
        public ByteBuffer RefPicList1() {
            return StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte RefPicList1(int index) {
            return StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
        public ByteBuffer list_entry_l0() {
            return StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address());
        }

        @NativeType(value="uint8_t")
        public byte list_entry_l0(int index) {
            return StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), index);
        }

        @NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]")
        public ByteBuffer list_entry_l1() {
            return StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address());
        }

        @NativeType(value="uint8_t")
        public byte list_entry_l1(int index) {
            return StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), index);
        }

        public Buffer flags(StdVideoEncodeH265ReferenceModificationFlags value) {
            StdVideoEncodeH265ReferenceModifications.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265ReferenceModificationFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer num_ref_idx_l0_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l0_active_minus1(this.address(), value);
            return this;
        }

        public Buffer num_ref_idx_l1_active_minus1(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nnum_ref_idx_l1_active_minus1(this.address(), value);
            return this;
        }

        public Buffer reserved1(@NativeType(value="uint16_t") short value) {
            StdVideoEncodeH265ReferenceModifications.nreserved1(this.address(), value);
            return this;
        }

        public Buffer RefPicList0(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), value);
            return this;
        }

        public Buffer RefPicList0(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nRefPicList0(this.address(), index, value);
            return this;
        }

        public Buffer RefPicList1(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), value);
            return this;
        }

        public Buffer RefPicList1(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nRefPicList1(this.address(), index, value);
            return this;
        }

        public Buffer list_entry_l0(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), value);
            return this;
        }

        public Buffer list_entry_l0(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nlist_entry_l0(this.address(), index, value);
            return this;
        }

        public Buffer list_entry_l1(@NativeType(value="uint8_t[STD_VIDEO_H265_MAX_NUM_LIST_REF]") ByteBuffer value) {
            StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), value);
            return this;
        }

        public Buffer list_entry_l1(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265ReferenceModifications.nlist_entry_l1(this.address(), index, value);
            return this;
        }
    }
}

